/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.support.remote.MiswsService;
import com.digiwin.dap.middleware.iam.support.remote.domain.ResignedEmployeeVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantShippingVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.misws.GetCustomerVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.misws.TenantCustomerVO;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MiswsServiceImpl
implements MiswsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiswsServiceImpl.class);
    public static final String G_CRMGG_QUERY = "g_CRMGG_Query";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    private static final String CONSULTANT_CRM_DATA_URL = "/ConsultantCRM_WebAPI/DigiwinCloud";
    private static final String APP_KEY = "757eacef9b082de6bf6958e233482fdb";
    private static final String APP_SECRET_SALT = "DigiwinCloud";
    private static final String API_PATH = "list_authorisation";
    private static final String APP_KEY_CMSMV = "CloudMarket";
    private static final String APP_KEY_TRIALCRMGG = "EScloudCRMGG";
    private static final String APP_KEY_CLOUDMARKET = "CloudMarket";

    @Override
    public TenantShippingVO getTenantInfo(String userEmail) {
        if (!StringUtils.isEmpty((CharSequence)this.envProperties.getMiswsUrl())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("app_key", APP_KEY);
            params.put("app_secret", this.getAppSecret(APP_SECRET_SALT));
            params.put("api_path", API_PATH);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("email", userEmail);
            params.put("data", dataMap);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
            try {
                LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79df\u6237\u8d44\u6599,url:{},\u5185\u5bb9\uff1a{}", (Object)this.envProperties.getMiswsUrl(), (Object)JsonUtils.writeValue(params));
                ResponseEntity responseEntity = this.restTemplate.postForEntity(this.envProperties.getMiswsUrl(), (Object)requestEntity, TenantShippingVO.class, new Object[0]);
                return (TenantShippingVO)responseEntity.getBody();
            }
            catch (Exception e) {
                LOGGER.error(ExceptionUtils.logError((String)"\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79df\u6237\u8d44\u6599\u5931\u8d25", (String)this.envProperties.getMiswsUrl(), (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
                throw new BusinessException((ErrorHandler)I18nError.MISWS_QUERY_TENANT_FAILED);
            }
        }
        LOGGER.error("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79df\u6237\u8d44\u6599\u5931\u8d25,\u8d44\u7ba1\u5730\u5740\u4e3a\u7a7a");
        return null;
    }

    @Override
    public ResignedEmployeeVO getResignedEmployee(String startDate, String endDate) {
        String cmsmvUrl = this.envProperties.getCmsmvUrl();
        if (!StringUtils.isEmpty((CharSequence)cmsmvUrl)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appkey", "CloudMarket");
            params.put("appsecret", this.getAppSecret("CloudMarket"));
            params.put("Isresign", "N");
            params.put("StartDate", startDate);
            params.put("EndDate", endDate);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
            try {
                LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79bb\u804c\u5458\u5de5\u4fe1\u606f,url:{},\u5185\u5bb9\uff1a{}", (Object)cmsmvUrl, (Object)JsonUtils.writeValue(params));
                return (ResignedEmployeeVO)this.restTemplate.postForObject(cmsmvUrl, (Object)requestEntity, ResignedEmployeeVO.class, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error(ExceptionUtils.logError((String)"\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79bb\u804c\u5458\u5de5\u4fe1\u606f\u5931\u8d25", (String)cmsmvUrl, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
                throw new BusinessException((ErrorHandler)I18nError.MISWS_QUERY_RESIGNED_EMPLOYEES_FAILED);
            }
        }
        LOGGER.error("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u79bb\u804c\u5458\u5de5\u4fe1\u606f\u5931\u8d25,\u8d44\u7ba1\u4eba\u5458\u8d44\u6599\u660e\u7ec6\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a");
        throw new BusinessException((ErrorHandler)I18nError.MISWS_QUERY_RESIGNED_EMPLOYEES_FAILED);
    }

    public static void main(String[] args) {
        String appSecret = "CloudMarket" + DateUtils.formatDatePure((TemporalAccessor)LocalDate.now());
        System.out.println(DigestUtils.md5Hex((String)appSecret));
    }

    private String getAppSecret(String appKey) {
        String appSecret = appKey + DateUtils.formatDatePure((TemporalAccessor)LocalDate.now());
        return DigestUtils.md5Hex((String)appSecret);
    }

    @Override
    public List<TenantCustomerVO> getMiswsTenant(String companyName, String taxNo) {
        String url = this.envProperties.getMiswsDomain() + this.envProperties.getCrmgg();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appkey", APP_KEY_TRIALCRMGG);
        params.put("appsecret", this.getAppSecret(APP_KEY_TRIALCRMGG));
        params.put("apiPath", G_CRMGG_QUERY);
        params.put("companyName", companyName);
        params.put("BusAccountingNO", taxNo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u6f5c\u5ba2\u4ee3\u53f7,url:{},\u5185\u5bb9\uff1a{}", (Object)url, (Object)JsonUtils.writeValue(params));
            return (List)this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<TenantCustomerVO>>(){}, new Object[0]).getBody();
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010Misws\u8c03\u7528\u3011 \u67e5\u8be2\u6f5c\u5ba2\u4ee3\u53f7", (String)url, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
            return new ArrayList<TenantCustomerVO>();
        }
    }

    @Override
    public boolean existInMisws(String potentialCustomerId) {
        if (StringUtils.isBlank((CharSequence)potentialCustomerId)) {
            return false;
        }
        String url = this.envProperties.getMiswsDomain() + this.envProperties.getGetCust();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appkey", "CloudMarket");
        params.put("appsecret", this.getAppSecret("CloudMarket"));
        params.put("CustNo", potentialCustomerId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            LOGGER.info("\u3010Misws\u8c03\u7528\u3011 \u6f5c\u5ba2\u4ee3\u53f7\u67e5\u8be2,url:{},\u5185\u5bb9\uff1a{}", (Object)url, (Object)JsonUtils.writeValue(params));
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, GetCustomerVO.class, new Object[0]);
            GetCustomerVO body = (GetCustomerVO)exchange.getBody();
            if (body != null && "0".equals(body.getStatus()) && !CollectionUtils.isEmpty(body.getData())) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010Misws\u8c03\u7528\u3011 \u6f5c\u5ba2\u4ee3\u53f7\u67e5\u8be2", (String)url, (Object)requestEntity.getBody(), (Exception)e), (Throwable)e);
        }
        return false;
    }
}

