/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.support.remote.OAuthLogin4HuaweiService;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginRequest;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginResponse;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthUserInfo;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class OAuthLogin4HuaweiServiceImpl
implements OAuthLogin4HuaweiService {
    private Logger logger = LoggerFactory.getLogger(OAuthLogin4HuaweiServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public OAuthLoginResponse getAppTenantToken(String uri, OAuthLoginRequest request) {
        block6: {
            if (!StringUtils.isEmpty((Object)uri)) {
                try {
                    String url = String.format("%s/api/v2/tenant/token?grant_type=client_credentials&client_id=%s&client_secret=%s", uri, request.getClientId(), request.getClientSecret());
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Type", "application/json");
                    this.logger.error("\u5e94\u7528app\u7aef\u9274\u6743:body:{}", (Object)JsonUtils.writeValue((Object)request));
                    HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                    ResponseEntity oAuthLoginResponse = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthLoginResponse>(){}, new Object[0]);
                    OAuthLoginResponse body = (OAuthLoginResponse)oAuthLoginResponse.getBody();
                    if (body != null) {
                        if (StringUtils.isEmpty((Object)body.getAccessToken())) {
                            throw new BusinessException("\u5e94\u7528app\u7aef\u9274\u6743\u5931\u8d25\uff1a" + body.getError());
                        }
                        return body;
                    }
                    break block6;
                }
                catch (HttpClientErrorException ex) {
                    throw new BusinessException("\u5e94\u7528app\u7aef\u9274\u6743\u5931\u8d25\uff1a" + ex.getResponseBodyAsString(), (Throwable)ex);
                }
                catch (Exception exception) {
                    throw new BusinessException("\u5e94\u7528app\u7aef\u9274\u6743\u5931\u8d25\uff1a", (Throwable)exception);
                }
            }
            throw new BusinessException("\u5e94\u7528app\u7aef\u9274\u6743\u5931\u8d25\uff1a\u534e\u4e3a\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        throw new BusinessException("\u5e94\u7528app\u7aef\u9274\u6743\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u5e94\u7528\u7684accessToken");
    }

    @Override
    public OAuthLoginResponse getSSOTicket(String uri, OAuthLoginRequest request) {
        block6: {
            if (!StringUtils.isEmpty((Object)uri)) {
                try {
                    String url = String.format("%s/api/v2/tenant/sso/session-token/sso-ticket", uri);
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Type", "application/json");
                    headers.add("Authorization", String.format("%s %s", request.getTokenType(), request.getAccessToken()));
                    HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
                    this.logger.error("\u5e94\u7528app\u7aef\u83b7\u53d6ticket\u5931\u8d25:uri:{},header:{},body:{}", new Object[]{url, JsonUtils.writeValue((Object)headers), JsonUtils.writeValue((Object)request)});
                    ResponseEntity oAuthLoginResponse = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthLoginResponse>(){}, new Object[0]);
                    OAuthLoginResponse body = (OAuthLoginResponse)oAuthLoginResponse.getBody();
                    if (body != null) {
                        if (StringUtils.isEmpty((Object)body.getSsoTicket())) {
                            throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6ticket\u5931\u8d25\uff1a" + body.getErrorMsg());
                        }
                        return body;
                    }
                    break block6;
                }
                catch (HttpClientErrorException ex) {
                    throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6ticket\u5931\u8d25\uff1a" + ex.getResponseBodyAsString(), (Throwable)ex);
                }
                catch (Exception exception) {
                    throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6ticket\u5931\u8d25\uff1a", (Throwable)exception);
                }
            }
            throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6ticket\u5931\u8d25\uff1a\u534e\u4e3a\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6ticket\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u5e94\u7528\u7684sso_ticket");
    }

    @Override
    public OAuthUserInfo verifySSOTicket(String uri, OAuthLoginRequest request) {
        block6: {
            if (!StringUtils.isEmpty((Object)uri)) {
                try {
                    String url = String.format("%s/api/v2/tenant/sso/sso-ticket/verify", uri);
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Type", "application/json");
                    headers.add("Authorization", String.format("%s %s", request.getTokenType(), request.getAccessToken()));
                    HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
                    this.logger.error("\u5e94\u7528app\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25:uri:{},header:{},body:{}", new Object[]{url, JsonUtils.writeValue((Object)headers), JsonUtils.writeValue((Object)request)});
                    ResponseEntity oAuthLoginResponse = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<OAuthLoginResponse>>(){}, new Object[0]);
                    StdData body = (StdData)oAuthLoginResponse.getBody();
                    if (body != null) {
                        if (body.getData() == null || ((OAuthLoginResponse)body.getData()).getUser() == null) {
                            throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + body.getMessage());
                        }
                        return ((OAuthLoginResponse)body.getData()).getUser();
                    }
                    break block6;
                }
                catch (HttpClientErrorException ex) {
                    throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + ex.getResponseBodyAsString(), (Throwable)ex);
                }
                catch (Exception exception) {
                    throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)exception);
                }
            }
            throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a\u534e\u4e3a\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        throw new BusinessException("\u5e94\u7528app\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
    }

    @Override
    public OAuthLoginResponse getWebAccessToken(String uri, OAuthLoginRequest request) {
        block6: {
            if (!StringUtils.isEmpty((Object)uri)) {
                try {
                    String url = String.format("%s/api/v1/oauth2/token?code=%s&grant_type=authorization_code&client_id=%s&client_secret=%s", uri, request.getCode(), request.getClientId(), request.getClientSecret());
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Type", "application/json");
                    HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                    this.logger.error("Web\u7aef\u83b7\u53d6\u5e94\u7528\u51ed\u8bc1\u5931\u8d25:uri:{},header:{},body:{}", new Object[]{url, JsonUtils.writeValue((Object)headers), JsonUtils.writeValue((Object)request)});
                    ResponseEntity oAuthLoginResponse = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthLoginResponse>(){}, new Object[0]);
                    OAuthLoginResponse body = (OAuthLoginResponse)oAuthLoginResponse.getBody();
                    if (body != null) {
                        if (StringUtils.isEmpty((Object)body.getAccessToken())) {
                            throw new BusinessException("\u5e94\u7528\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25\uff1a" + body.getError());
                        }
                        return body;
                    }
                    break block6;
                }
                catch (HttpClientErrorException ex) {
                    throw new BusinessException("\u5e94\u7528\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25\uff1a" + ex.getResponseBodyAsString(), (Throwable)ex);
                }
                catch (Exception exception) {
                    throw new BusinessException("\u5e94\u7528\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25\uff1a" + exception.getMessage(), (Throwable)exception);
                }
            }
            throw new BusinessException("\u5e94\u7528\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25\uff1a\u534e\u4e3a\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        throw new BusinessException("\u5e94\u7528\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u5e94\u7528\u7684accessToken");
    }

    @Override
    public OAuthUserInfo getUserInfo(String uri, OAuthLoginRequest request) {
        block6: {
            if (!StringUtils.isEmpty((Object)uri)) {
                try {
                    String url = String.format("%s/api/v1/oauth2/userinfo", uri);
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Type", "application/json");
                    headers.add("Authorization", String.format("%s %s", request.getTokenType(), request.getAccessToken()));
                    HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                    this.logger.error("Web\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25:uri:{},header:{},body:{}", new Object[]{url, JsonUtils.writeValue((Object)headers), JsonUtils.writeValue((Object)request)});
                    ResponseEntity oAuthLoginResponse = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<OAuthUserInfo>(){}, new Object[0]);
                    OAuthUserInfo body = (OAuthUserInfo)oAuthLoginResponse.getBody();
                    if (body != null) {
                        if (StringUtils.isEmpty((Object)body.getUserName())) {
                            throw new BusinessException("\u5e94\u7528web\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + body.getError());
                        }
                        return body;
                    }
                    break block6;
                }
                catch (HttpClientErrorException ex) {
                    throw new BusinessException("\u5e94\u7528web\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + ex.getResponseBodyAsString(), (Throwable)ex);
                }
                catch (Exception exception) {
                    throw new BusinessException("\u5e94\u7528web\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)exception);
                }
            }
            throw new BusinessException("\u5e94\u7528web\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a\u534e\u4e3a\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        throw new BusinessException("\u5e94\u7528web\u7aef\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
    }
}

