/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.util.CollectionUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.domain.tenant.MultiTenantsVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.support.remote.domain.OrderUpdateTenantVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.PreOrderVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterInfoDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.omc.CloudDeviceConditionVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.omc.OmcPreOrderVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.omc.OrderCloudDeviceVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.omc.OrderListResult;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class OmcServiceImpl
implements OmcService {
    private static final Logger logger = LoggerFactory.getLogger(OmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RemoteIamService remoteIamService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addPreOrder(String uri, String appId, Tenant tenant) {
        try {
            if (!StringUtils.isEmpty((Object)uri)) {
                String url = String.format("%s/api/omc/v2/pre/order/test", uri);
                logger.info("[{}]\u521b\u5efa\u79df\u6237[{}]\u4e0b\u5e94\u7528[{}]\u7684\u4eba\u5de5\u6388\u6743\u4fe1\u606f\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a{}", new Object[]{LocalDateTime.now(), tenant.getId(), appId, url});
                PreOrderVO preOrderVO = new PreOrderVO(appId, tenant);
                HttpHeaders headers = new HttpHeaders();
                String userToken = UserUtils.getToken();
                if (StringUtils.isEmpty((Object)userToken)) {
                    userToken = this.remoteIamService.getUserToken(tenant.getId());
                }
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
                HttpEntity httpEntity = new HttpEntity((Object)preOrderVO, (MultiValueMap)headers);
                StdData stdData = (StdData)this.restTemplate.postForObject(url, (Object)httpEntity, StdData.class, new Object[0]);
                if (null == stdData || 200 != stdData.getCode()) throw new BusinessException((ErrorHandler)I18nError.TENANT_CREATE_ORDER_FAILED, new Object[]{tenant.getId(), appId});
                Boolean resultData = (Boolean)stdData.getData();
                if (resultData != null && resultData.booleanValue()) return;
                throw new BusinessException((ErrorHandler)I18nError.TENANT_CREATE_ORDER_FAILED, new Object[]{tenant.getId(), appId});
            }
            logger.error("\u8ba2\u5355\u4e2d\u5fc3\u6d4b\u8bd5\u73af\u5883\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
            return;
        }
        catch (Exception ex) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_CREATE_ORDER_FAILED, new Object[]{tenant.getId(), appId});
        }
    }

    @Override
    public void OrderUpdateTestTenant(String tenantId, boolean testTenant) {
        Assert.notNull((Object)tenantId, (String)"tenantId is null");
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getOmcUri())) {
                String url = this.envProperties.getOmcUri() + "/api/omc/v2/order/update/tenant";
                OrderUpdateTenantVO orderUpdateTenantVO = new OrderUpdateTenantVO();
                orderUpdateTenantVO.setTenantId(tenantId);
                orderUpdateTenantVO.setTestTenant(testTenant);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                HttpEntity request = new HttpEntity((Object)orderUpdateTenantVO, (MultiValueMap)headers);
                this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            } else {
                logger.error("\u8ba2\u5355\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.UPDATE_ORDER_FAILED);
        }
    }

    @Override
    public void deleteOrdersByTenant(Long tenantSid) {
        Assert.notNull((Object)tenantSid, (String)"tenantId is null");
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getOmcUri())) {
                String url = String.format("%s/api/omc/v2/%s/orders", this.envProperties.getOmcUri(), tenantSid);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                this.restTemplate.exchange(url, HttpMethod.DELETE, request, String.class, new Object[0]);
            } else {
                logger.error("\u8ba2\u5355\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u79df\u6237\u8ba2\u5355\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Boolean purchaseApp(String tenantId, List<GoodsAuthDO> goodsAuthDOList) {
        StdData body = this.doPurchaseApp(tenantId, goodsAuthDOList);
        if (null == body) {
            logger.error("OMC\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u521d\u59cb\u5316\u5931\u8d25");
            throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
        }
        if (!body.getSuccess().booleanValue()) {
            logger.error("OMC\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)body.getMessage());
            return body.getSuccess();
        }
        return true;
    }

    @Override
    public boolean purchaseAppWithException(String tenantId, List<GoodsAuthDO> goodsAuthDOList) {
        StdData body = this.doPurchaseApp(tenantId, goodsAuthDOList);
        if (null == body) {
            logger.error("OMC\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u521d\u59cb\u5316\u5931\u8d25");
            throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
        }
        if (!body.getSuccess().booleanValue()) {
            logger.error("OMC\u5f00\u901a\u6388\u6743\u4ee5\u53ca\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)body.getMessage());
            throw new BusinessException(body.getMessage());
        }
        return true;
    }

    @Nullable
    private StdData doPurchaseApp(String tenantId, List<GoodsAuthDO> goodsAuthDOList) {
        String uri = this.envProperties.getOmcUri() + "/api/omc/v2/sys/authorization";
        String json = JsonUtils.writeValue(goodsAuthDOList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(tenantId) : UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, StdData.class, new Object[0]);
        StdData body = (StdData)response.getBody();
        return body;
    }

    @Override
    public void batchInitializeApps(CopyAppAuthVO copyAppAuthVO) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getOmcUri())) {
                String uri = this.envProperties.getOmcUri() + "/api/omc/v2/sys/initialize";
                String json = JsonUtils.writeValue((Object)copyAppAuthVO);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(copyAppAuthVO.getTenantId()) : UserUtils.getToken());
                HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
                ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
                if (!response.getStatusCode().is2xxSuccessful()) {
                    throw new BusinessException((ErrorHandler)I18nError.CAC_AUTHORIZATION_FAILED);
                }
            } else {
                logger.error("\u8ba2\u5355\u4e2d\u5fc3\u5730\u5740\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u521d\u59cb\u5316\u6216\u7eed\u7ea6\u5931\u8d25,{}", (Object)JsonUtils.writeValue((Object)copyAppAuthVO), (Object)e);
        }
    }

    @Override
    public List<OmcPreOrderVO> queryPreOrder(List<String> sourceCodes) {
        if (CollectionUtils.isEmpty(sourceCodes)) {
            return new ArrayList<OmcPreOrderVO>();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = StrUtil.format((CharSequence)"{}/api/omc/v2/pre/orders?pageSize={}&params={json}", (Object[])new Object[]{this.envProperties.getOmcUri(), 9999});
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        data.put("sourceBillCodes", sourceCodes);
        String json = JsonUtils.objToJson(data);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<PageSerializable<OmcPreOrderVO>>>(){}, new Object[]{json});
        return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).map(PageSerializable::getList).orElse(new ArrayList());
    }

    @Override
    public List<OrderCloudDeviceVO> queryCloudDevice(CloudDeviceConditionVO condition) {
        if (CollectionUtils.isEmpty(condition.getOrderSids())) {
            return new ArrayList<OrderCloudDeviceVO>();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)condition, (MultiValueMap)headers);
        String url = this.envProperties.getOmcUri() + "/api/omc/v2/device/cloud/backend/search";
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<PageSerializable<OrderCloudDeviceVO>>>(){}, new Object[0]);
        return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).map(PageSerializable::getList).orElse(new ArrayList());
    }

    @Override
    public void copySubTenantPreOrders(MultiTenantsVO input) {
        try {
            String uri = this.envProperties.getOmcUri() + "/api/omc/v2/pre/copy/sub";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)input, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Object.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
            }
        }
        catch (Exception e) {
            logger.error("\u8865\u5f85\u5f00\u901a\u5355\u5931\u8d25,{}", (Object)JsonUtils.writeValue((Object)input), (Object)e);
            throw new BusinessException((ErrorHandler)I18nError.COPY_TENANT_AUTHORIZATION);
        }
    }

    @Override
    public void registerDevice(List<PurchaseRegisterInfoDTO> registerInfos) {
        try {
            String uri = this.envProperties.getOmcUri() + "/api/omc/v2/device/register";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity(registerInfos, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Object.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
            }
        }
        catch (Exception e) {
            logger.error("\u5f00\u901a\u8bbe\u5907\u6570\u636e\u5f02\u5e38,{}", (Object)JsonUtils.writeValue(registerInfos), (Object)e);
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public OrderListResult getOrdersByTenantId(String tenantId) {
        String uri = this.envProperties.getOmcUri() + "/api/omc/v2/orders/tenant" + "?userId={userId}&pageIndex={pageIndex}&size={size}&params={params}&include={include}";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("userId", tenantId);
        paramMap.put("pageIndex", 1);
        paramMap.put("size", 1);
        paramMap.put("include", 2);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderType", 4);
        params.put("multiStates", Arrays.asList(0, 3));
        paramMap.put("params", JsonUtils.objToJson(params));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, OrderListResult.class, paramMap);
            return (OrderListResult)Optional.ofNullable(response.getBody()).orElse(new OrderListResult());
        }
        catch (Exception e) {
            logger.error("\u3010\u6839\u636e\u79df\u6237[{}]\u83b7\u53d6\u6240\u6709\u7684\u8ba2\u5355\u3011\u5931\u8d25", (Object)tenantId, (Object)e);
            throw new BusinessException(StrUtil.format((CharSequence)"\u3010\u6839\u636e\u79df\u6237[{}]\u83b7\u53d6\u6240\u6709\u7684\u8ba2\u5355\u3011\u5931\u8d25", (Object[])new Object[]{tenantId}));
        }
    }
}

