/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.iam.domain.token.OtaParameter;
import com.digiwin.dap.middleware.iam.domain.token.OtaResponseVO;
import com.digiwin.dap.middleware.iam.support.remote.OtaCallBackService;
import com.digiwin.dap.middleware.iam.support.remote.impl.KanBanServiceImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OtaCallBackServiceImpl
implements OtaCallBackService {
    @Autowired
    private RestTemplate restTemplate;
    private static final Logger logger = LoggerFactory.getLogger(KanBanServiceImpl.class);

    @Override
    public OtaResponseVO callBack(String callback, OtaParameter otaParameter) {
        try {
            OtaResponseVO otaResponse = new OtaResponseVO();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((Object)otaParameter, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(callback, (Object)request, Map.class, new Object[0]);
            int code = response.getStatusCodeValue();
            if (code == HttpStatus.OK.value() || code == HttpStatus.ACCEPTED.value()) {
                otaResponse.setCode(response.getStatusCodeValue());
                otaResponse.setResult(true);
                otaResponse.setDescription(response.toString());
            } else {
                otaResponse.setCode(response.getStatusCodeValue());
                otaResponse.setResult(false);
                otaResponse.setDescription(String.format("Http status code not 200 : [%s], response : [%s]", code, response.toString()));
            }
            return otaResponse;
        }
        catch (Exception e) {
            logger.error("ota\u56de\u8c03\u5931\u8d25\uff01", (Throwable)e);
            return new OtaResponseVO();
        }
    }
}

