/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.domain.CacRecordSourceEnum;
import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.PurchaseService;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PurchaseServiceImpl
implements PurchaseService {
    private final Logger logger = LoggerFactory.getLogger(PurchaseServiceImpl.class);
    @Autowired
    private OmcService omcService;

    @Override
    public void purchaseAuth(String tenantId, GoodsAuthDO goodsAuth) {
        try {
            goodsAuth.setSourceId(CacRecordSourceEnum.DirectAuthorization.getId());
            this.omcService.purchaseApp(tenantId, Collections.singletonList(goodsAuth));
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.UNEXPECTED, e.getMessage());
        }
    }

    @Override
    public void purchaseAuth(Tenant tenant, AuthDataDO authApp, List<String> userIds) {
        try {
            ArrayList<GoodsAuthDO> goodsAuthDOList = new ArrayList<GoodsAuthDO>();
            goodsAuthDOList.add(this.createGoods(tenant, authApp, userIds));
            this.omcService.purchaseApp(tenant.getId(), goodsAuthDOList);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.UNEXPECTED, e.getMessage());
        }
    }

    @Override
    public void batchPurchaseAuth(Tenant tenant, List<AuthDataDO> authApps, List<String> userIds) {
        try {
            ArrayList<GoodsAuthDO> goodsAuthDOList = new ArrayList<GoodsAuthDO>();
            authApps.forEach(a -> goodsAuthDOList.add(this.createGoods(tenant, (AuthDataDO)a, userIds)));
            this.omcService.purchaseApp(tenant.getId(), goodsAuthDOList);
        }
        catch (Exception ex) {
            this.logger.error("\u6388\u6743\u5e94\u7528\u5931\u8d25\uff0c{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private GoodsAuthDO createGoods(Tenant tenant, AuthDataDO authDataDO, List<String> userIds) {
        GoodsAuthDO goodsAuthDO = new GoodsAuthDO(authDataDO, tenant, userIds);
        goodsAuthDO.setAction(0);
        goodsAuthDO.setUpdateTenantAuth(!Boolean.FALSE.equals(authDataDO.getUpdateTenantAuth()));
        if (authDataDO.getUserNumber() == null && authDataDO.getEffectiveDateTime() == null && authDataDO.getExpiredDateTime() == null && StringUtils.isEmpty((Object)authDataDO.getStrategyCode())) {
            goodsAuthDO.setAction(1);
        }
        goodsAuthDO.setSourceId(CacRecordSourceEnum.DirectAuthorization.getId());
        goodsAuthDO.setMemo(authDataDO.getMemo());
        return goodsAuthDO;
    }
}

