/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.support.remote.RemoteBossIamService;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.github.pagehelper.PageSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteBossIamServiceImpl
implements RemoteBossIamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteBossIamServiceImpl.class);
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;

    @Override
    public List<TenantVO> getBossTenantQueryVos(String bossIamUri, String userToken, List<String> tenantIds) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        HashMap<String, Object> uriVariablesMap = new HashMap<String, Object>();
        uriVariablesMap.put("pageNum", 1);
        uriVariablesMap.put("pageSize", 9999);
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        paramsMap.put("tenantIds", tenantIds);
        uriVariablesMap.put("params", JsonUtils.objToJson(paramsMap));
        String url = bossIamUri + "/api/boss/v1/tenants" + "?pageNum={pageNum}&pageSize={pageSize}&params={params}";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<PageSerializable<TenantVO>>(){}, uriVariablesMap);
            return Optional.ofNullable(responseEntity.getBody()).map(PageSerializable::getList).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010\u8c03\u7528BOSSIAM\u3011 \u67e5\u8be2\u6240\u6709\u79df\u6237[\u5206\u9875]", (String)url, (Object)request.getBody(), (Exception)e), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

