/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.user.EmailMessage;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteException;
import com.digiwin.dap.middleware.iam.support.remote.domain.ThirdUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.emc.AppConfigVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.Message;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteEMCServiceImpl
implements RemoteEMCService {
    private Logger logger = LoggerFactory.getLogger(RemoteEMCServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    private static final String GET_WECHAT_USERS = "/api/emc/v1/appconfig/wechat/users";
    private static final String APPCONFIG_TENANT = "/api/emc/v1/appconfig/tenantid/%s";
    private static final String DINGDING_USER_EXIST = "/api/emc/v1/appconfig/dingding/user/exist";

    @Override
    public Map<String, String> getVerificationCode(String account, String scene) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                String url = this.envProperties.getEmcUri() + String.format("/api/emc/v1/getVerificationCode/email/%s/%s", account, scene);
                Map response = (Map)this.restTemplate.getForObject(url, HashMap.class, new Object[0]);
                return response;
            }
            this.logger.info("emcRootUri is empty !");
            return new HashMap<String, String>();
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public boolean checkVerificationCode(String account, String scene, String verificationCode) {
        return this.checkVerificationCode(account, scene, verificationCode, null);
    }

    @Override
    public boolean checkVerificationCode(String account, String scene, String verificationCode, String type) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                String url = type != null ? this.envProperties.getEmcUri() + String.format("/api/emc/v1/checkVerificationCode/%s/%s/%s/%s", account, scene, verificationCode, type) : this.envProperties.getEmcUri() + String.format("/api/emc/v1/checkVerificationCode/%s/%s/%s", account, scene, verificationCode);
                ResponseEntity responseEntity = this.dapRetryRestTemplate.postForEntity(url, (Object)request, HashMap.class, new Object[0]);
                String result = "result";
                String success = "success";
                return responseEntity.getBody() != null && success.equals(((HashMap)Objects.requireNonNull(responseEntity.getBody())).get(result));
            }
            this.logger.info("emcRootUri is empty !");
            return false;
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void sendMessage(EmailMessage message, int retryCount) {
        try {
            if (StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/sendEmail";
            this.restTemplate.postForEntity(url, (Object)message, ArrayList.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void sendMessage(Message message, int retryCount) {
        try {
            if (StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/send";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity body = new HttpEntity((Object)message, (MultiValueMap)headers);
            this.restTemplate.postForEntity(url, (Object)body, ArrayList.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void updateCorpids(String tenantId, String corpId) {
        try {
            if (StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/appconfig/corpids";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HashMap<String, String> paramsDTO = new HashMap<String, String>();
            paramsDTO.put("tenantId", tenantId);
            paramsDTO.put("corpId", corpId);
            HttpEntity body = new HttpEntity(paramsDTO, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)body, StdData.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public List<String> getWechatUsers(String appId, String tenantId) {
        try {
            Object data;
            if (StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            String url = this.envProperties.getEmcUri() + GET_WECHAT_USERS;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HashMap<String, String> paramsDTO = new HashMap<String, String>();
            paramsDTO.put("appId", appId);
            paramsDTO.put("tenantId", tenantId);
            HttpEntity body = new HttpEntity(paramsDTO, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.postForEntity(url, (Object)body, StdData.class, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            if (responseEntity.getStatusCode().is2xxSuccessful() && entityBody != null && (data = entityBody.getData()) instanceof List) {
                return (List)data;
            }
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Map<String, Object>> findAppConfigByTenantId(String tenantId) {
        try {
            Object data;
            if (StringUtils.isEmpty((Object)this.envProperties.getEmcUri())) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
            }
            String url = this.envProperties.getEmcUri() + String.format(APPCONFIG_TENANT, tenantId);
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, requestEntity, StdData.class, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            if (responseEntity.getStatusCode().is2xxSuccessful() && entityBody != null && (data = entityBody.getData()) instanceof List) {
                return (List)data;
            }
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
        return Collections.emptyList();
    }

    @Override
    public void sendEmailByEventId(String emcUri, MessageBody registerInfo) {
        try {
            String url = String.format("%s/api/emc/v1/message/email", emcUri);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("data", registerInfo.getData());
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("eventId", registerInfo.getOpType());
            requestBody.put("message", data);
            HttpEntity requestEntity = new HttpEntity(requestBody);
            this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, StdData.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void doAfterUserExitTenant(Long tenantSid, long sid) {
        try {
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/center/receiver/exit/tenant";
            HashMap<String, Long> requestBody = new HashMap<String, Long>();
            requestBody.put("tenantSid", tenantSid);
            requestBody.put("sid", sid);
            HttpEntity requestEntity = new HttpEntity(requestBody);
            this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getWeComUserId(String tenantId, String agentId, String authCode) {
        try {
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/wechat/user/oauth/access";
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("tenantId", tenantId);
            requestBody.put("agentId", agentId);
            requestBody.put("authCode", authCode);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<String>>(){}, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            return Optional.ofNullable(entityBody).map(StdData::getData).orElse(null);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public WeComUserVO getWeComUserInfo(String tenantId, String agentId, String authCode, boolean includeDetail) {
        try {
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/wechat/user/oauth/detail";
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("tenantId", tenantId);
            requestBody.put("agentId", agentId);
            requestBody.put("authCode", authCode);
            requestBody.put("includeDetail", includeDetail);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<WeComUserVO>>(){}, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            return Optional.ofNullable(entityBody).map(StdData::getData).orElse(null);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public WeComUserVO checkWechatExistReturnOpenUserId(String appId, String tenantId, String wechat, String userId) {
        return this.checkWechatExistReturnOpenUserId(appId, tenantId, wechat, userId, UserUtils.getToken());
    }

    @Override
    public WeComUserVO checkWechatExistReturnOpenUserId(String appId, String tenantId, String wechat, String userId, String userToken) {
        try {
            String url = this.envProperties.getEmcUri() + "/api/emc/v1/appconfig/wechat/exist/openuserid";
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("tenantId", tenantId);
            requestBody.put("wechat", wechat);
            requestBody.put("appId", appId);
            requestBody.put("userId", userId);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", userToken);
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<WeComUserVO>>(){}, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            if (Objects.nonNull(entityBody)) {
                return (WeComUserVO)entityBody.getData();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public ThirdUserVO checkDingdingExist(String appId, String tenantId, String dingding, String userId) {
        try {
            String url = this.envProperties.getEmcUri() + DINGDING_USER_EXIST;
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("tenantId", tenantId);
            requestBody.put("thirdUserId", dingding);
            requestBody.put("appId", appId);
            requestBody.put("userId", userId);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<ThirdUserVO>>(){}, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            if (Objects.nonNull(entityBody)) {
                return (ThirdUserVO)entityBody.getData();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<AppConfigVO> findAppConfig(String tenantId, String appType, String appCategory) {
        try {
            String url = this.envProperties.getEmcUri() + String.format("/api/emc/v1/appconfig/tenantid/%s?type=%s&category=%s", tenantId, appType, appCategory);
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<AppConfigVO>>>(){}, new Object[0]);
            StdData entityBody = (StdData)responseEntity.getBody();
            if (responseEntity.getStatusCode().is2xxSuccessful() && entityBody != null) {
                return (List)entityBody.getData();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }
}

