/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCompanyVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCopyVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.UserDeptInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdTenantInfoDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.eoc.AutoEOCVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserBO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserVO;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteEocServiceImpl
implements RemoteEocService {
    private Logger logger = LoggerFactory.getLogger(RemoteEocServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    private static final String URL_GET_EMP_BY_TENANT = "/api/eoc/v2/emp/tenant/user/id/info";
    private static final String URL_POST_EMP_INFO = "/api/eoc/v2/emp/info";
    private static final String URL_DEL_EMP_USER = "/api/eoc/v2/emp/user/id/del";
    private static final String URL_CHANGE_EMP_STATUS = "/api/eoc/v2/emp/force/status/change";
    private static final String URL_BATCH_CHANGE_EMP_STATUS = "/api/eoc/v2/emp/force/status/change/batch";
    public static final String TENANT_AD_USER_SYNC = "/api/eoc/v2/tenant/ad/user/sync";
    public static final String TENANT_AD_OU_SYNC = "/api/eoc/v2/tenant/ad/ou/sync";
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private DapHttpService dapHttpService;

    @Override
    public void initialize(TenantInfoVO tenantInfoVO) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
                String uri = String.format("%s%s", this.envProperties.getEocUri(), this.envProperties.getEocInitializeUrl());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                HttpEntity request = new HttpEntity((Object)tenantInfoVO, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)request, Map.class, new Object[0]);
                if (responseEntity.getBody() != null && !((Boolean)((Map)responseEntity.getBody()).get("success")).booleanValue()) {
                    throw new BusinessException((ErrorHandler)I18nError.TENANT_INIT_ENTERPRISE_OPERATIONS_FAILED, new Object[]{tenantInfoVO.getId()});
                }
            } else {
                this.logger.info("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void refreshUserName(User user, String userToken) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
                String uri = String.format("%s/api/eoc/v2/emp/user/update/name", this.envProperties.getEocUri());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, ObjectUtils.isEmpty((Object)userToken) ? this.dapHttpService.getUserToken("99990000") : userToken);
                HttpEntity request = new HttpEntity((Object)user, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)request, Map.class, new Object[0]);
                if (responseEntity.getBody() != null && !((Boolean)((Map)responseEntity.getBody()).get("success")).booleanValue()) {
                    this.logger.error("\u66f4\u65b0\u5458\u5de5%s\u7ed1\u5b9a\u7528\u6237\u540d\u79f0\u5931\u8d25" + user.getId());
                }
            } else {
                this.logger.info("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteByTenant(Long tenantSid) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            try {
                String uri = String.format("%s/api/eoc/v2/tenant/remove", this.envProperties.getEocUri());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                HashMap<String, Long> requestBody = new HashMap<String, Long>();
                requestBody.put("sid", tenantSid);
                HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, Object.class, new Object[0]);
                if (responseEntity.getBody() == null || responseEntity.getStatusCode() == HttpStatus.OK) return;
                this.logger.error(String.format("\u5220\u9664\u79df\u6237%s\u6240\u6709\u4f01\u4e1a\u8fd0\u8425\u4fe1\u606f\u5931\u8d25", tenantSid));
                return;
            }
            catch (Exception e) {
                throw new BusinessException((ErrorHandler)I18nError.DELETE_TENANT_ENTERPRISE_OPERATIONS_FAILED, new Object[]{tenantSid});
            }
        } else {
            this.logger.info("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void copyAllInfo(Tenant sourceTenant, Tenant tenant) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            try {
                String uri = String.format("%s/api/eoc/v2/tenant/copy/all", this.envProperties.getEocUri());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                HashMap<String, Object> requestBody = new HashMap<String, Object>();
                requestBody.put("sid", tenant.getSid());
                requestBody.put("id", tenant.getId());
                requestBody.put("name", tenant.getName());
                requestBody.put("sourceTenantSid", sourceTenant.getSid());
                requestBody.put("sourceTenantId", sourceTenant.getId());
                HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, Object.class, new Object[0]);
                if (responseEntity.getBody() == null || responseEntity.getStatusCode() == HttpStatus.OK) return;
                this.logger.error(String.format("\u79df\u6237%s\u590d\u5236\u6765\u6e90\u79df\u6237%s\u7684\u6240\u6709\u4f01\u4e1a\u8fd0\u8425\u4fe1\u606f\u5931\u8d25", tenant.getId(), sourceTenant.getId()));
                return;
            }
            catch (Exception e) {
                throw new BusinessException((ErrorHandler)I18nError.COPY_TENANT_ENTERPRISE_OPERATIONS_FAILED, new Object[]{tenant.getId(), sourceTenant.getId()});
            }
        } else {
            this.logger.info("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public Map<String, Integer> copyAndCompare(TenantCopyVO vo) {
        try {
            String uri = String.format("%s/api/eoc/v2/tenant/copy/compare", this.envProperties.getEocUri());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("tenantSid", vo.getTenantSid());
            requestBody.put("tenantId", vo.getTenantId());
            requestBody.put("sourceTenantSid", vo.getSourceTenantSid());
            requestBody.put("sourceTenantId", vo.getSourceTenantId());
            requestBody.put("eocType", vo.getEocType());
            requestBody.put("copyCorps", vo.getCopyCorps());
            HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, StdData.class, new Object[0]);
            if (responseEntity.getBody() != null && responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logger.error(String.format("\u79df\u6237%s\u590d\u5236\u6765\u6e90\u79df\u6237%s\u7684\u6240\u6709\u4f01\u4e1a\u8fd0\u8425\u4fe1\u606f\u5931\u8d25", vo.getTenantId(), vo.getSourceTenantId()));
            }
            return (Map)((StdData)responseEntity.getBody()).getData();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.COPY_TENANT_ENTERPRISE_OPERATIONS_FAILED, new Object[]{vo.getTenantId(), vo.getSourceTenantId()});
        }
    }

    @Override
    public String exportAllInfo(Long tenantSid, String token) {
        try {
            String uri = String.format("%s/api/eoc/v2/tenant/export/all", this.envProperties.getEocUri());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, token);
            HashMap<String, Long> requestBody = new HashMap<String, Long>();
            requestBody.put("sid", tenantSid);
            HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, Map.class, new Object[0]);
            if (responseEntity.getBody() != null) {
                if (responseEntity.getStatusCode() != HttpStatus.OK) {
                    this.logger.error(String.format("\u5bfc\u51fa\u79df\u6237%s\u7684\u6240\u6709\u4f01\u4e1a\u8fd0\u8425\u4fe1\u606f\u5931\u8d25", tenantSid));
                } else if (null != ((Map)responseEntity.getBody()).get("data")) {
                    return (String)((Map)responseEntity.getBody()).get("data");
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public void bindingUser(EmpUserVO empUser) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            try {
                String uri = String.format("%s/api/eoc/v2/emp/binding/user", this.envProperties.getEocUri());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
                HttpEntity httpEntity = new HttpEntity((Object)empUser, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, Object.class, new Object[0]);
                if (responseEntity.getBody() != null && responseEntity.getStatusCode() != HttpStatus.OK) {
                    this.logger.error(String.format("\u79df\u6237%s \u4e0b\u7528\u6237%s \u5173\u8054\u5458\u5de5%s \u5931\u8d25", empUser.getTenantSid(), empUser.getUserName(), empUser.getEmpId()));
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("\u79df\u6237%s \u4e0b\u7528\u6237%s \u5173\u8054\u5458\u5de5%s \u5931\u8d25", empUser.getTenantSid(), empUser.getUserName(), empUser.getEmpId()));
            }
        } else {
            this.logger.info("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public Boolean checkEmpIdExists(String empId, String tenantId) {
        Boolean exist = null;
        String url = this.envProperties.getEocUri() + String.format("/api/eoc/v2/emp/exists/%s", empId);
        String userToken = this.remoteIamService.getUserToken(tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity resultEntity = this.restTemplate.exchange(url, HttpMethod.GET, request, StdData.class, new Object[0]);
        if (resultEntity.getStatusCode().is2xxSuccessful()) {
            exist = (Boolean)((StdData)resultEntity.getBody()).getData();
        }
        return exist;
    }

    @Override
    public EmpInfoVO getEmpByTenant(Long tenantSid, String empId) {
        String url = this.envProperties.getEocUri() + URL_GET_EMP_BY_TENANT;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("tenantSid", tenantSid);
        requestBody.put("id", empId);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<EmpInfoVO>>(){}, new Object[0]);
        return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(null);
    }

    @Override
    public EmpInfoVO getEmpByUserId(String userId, Boolean showException) {
        String url = this.envProperties.getEocUri() + URL_POST_EMP_INFO;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("userId", userId);
        requestBody.put("showException", showException);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<EmpInfoVO>>(){}, new Object[0]);
        return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(null);
    }

    @Override
    public List<EmpInfoVO> getEmpByUserIds(List<String> userIds) {
        try {
            String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/infos";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, List<String>> requestBody = new HashMap<String, List<String>>();
            requestBody.put("userIds", userIds);
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<EmpInfoVO>>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4e0b\u7684\u7528\u6237{}\u7ed1\u5b9a\u5458\u5de5\u5931\u8d25", userIds, (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public EmpInfoVO getEmpByTenantAndUserId(Long tenantSid, String userId) {
        try {
            String url = String.format("%s/api/eoc/v2/emp/user/info", this.envProperties.getEocUri());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("userId", userId);
            requestBody.put("tenantSid", tenantSid);
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<EmpInfoVO>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(null);
        }
        catch (Exception ex) {
            this.logger.error("\u83b7\u53d6\u79df\u6237{}\u4e0b\u7684\u7528\u6237{}\u7ed1\u5b9a\u5458\u5de5\u5931\u8d25", new Object[]{tenantSid, userId, ex});
            return null;
        }
    }

    @Override
    public void batchBindingUser(TenantInfoVO tenantInfoVO, String deptId, List<EmpUserVO> empUsers) {
        if (empUsers.isEmpty() && !tenantInfoVO.getEoc().booleanValue()) {
            return;
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("sid", tenantInfoVO.getSid());
        request.put("id", tenantInfoVO.getId());
        request.put("name", tenantInfoVO.getName());
        request.put("deptId", deptId);
        request.put("users", empUsers);
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/emp/binding/user/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(tenantInfoVO.getId()) : UserUtils.getToken());
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)headers);
        try {
            this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error("\u7ed1\u5b9a\u5458\u5de5\u4fe1\u606f\u5931\u8d25", (Throwable)ex);
        }
    }

    @Override
    public void deleteUserEmp(Long tenantSid, String userId) {
        if (StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            this.logger.error("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("tenantSid", tenantSid);
        paramsMap.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity(paramsMap, (MultiValueMap)headers);
        String uri = this.envProperties.getEocUri() + URL_DEL_EMP_USER;
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, StdData.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.logger.error("\u5220\u9664EOC\u4e2d\u7528\u6237\u7ed1\u5b9a\u7684\u5458\u5de5\u5173\u7cfb \u5931\u8d25\uff0cuserId={}", (Object)userId);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664EOC\u4e2d\u7528\u6237\u7ed1\u5b9a\u7684\u5458\u5de5\u5173\u7cfb \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void changeEmpStatus(long tenantSid, String id, boolean status, String userToken) {
        if (StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            this.logger.error("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("tenantSid", tenantSid);
        paramsMap.put("userId", id);
        paramsMap.put("status", status);
        HttpEntity httpEntity = new HttpEntity(paramsMap, (MultiValueMap)headers);
        String uri = this.envProperties.getEocUri() + URL_CHANGE_EMP_STATUS;
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, StdData.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.logger.error("\u505c\u7528EOC\u4e2d\u7528\u6237 \u5931\u8d25\uff0cuserId={}", (Object)id);
            }
        }
        catch (Exception e) {
            this.logger.error("\u505c\u7528EOC\u4e2d\u7528\u6237 \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void batchChangeEmpStatus(long tenantSid, List<String> userIds, boolean b) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("tenantSid", tenantSid);
        paramsMap.put("userIds", userIds);
        HttpEntity httpEntity = new HttpEntity(paramsMap, (MultiValueMap)headers);
        String uri = this.envProperties.getEocUri() + URL_BATCH_CHANGE_EMP_STATUS;
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, StdData.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.logger.error("\u505c\u7528EOC\u4e2d\u7528\u6237 \u5931\u8d25\uff0cuserId={}", userIds);
            }
        }
        catch (Exception e) {
            this.logger.error("\u505c\u7528EOC\u4e2d\u7528\u6237 \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public List<String> getDirectDepts(String userId, Integer level) {
        List<String> deptIds = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            this.logger.error("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return deptIds;
        }
        String uri = String.format("%s/api/eoc/v2/emp/direct/dept/all", this.envProperties.getEocUri());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("userId", userId);
        requestBody.put("level", level);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, new HttpEntity(requestBody, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<UserDeptInfoVO>>>(){}, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful() || null == responseEntity.getBody()) {
                this.logger.error("\u83b7\u53d6\u79df\u6237\u4e0b{}\u7528\u6237{}\u7684\u6240\u5c5e\u90e8\u95e8\u5931\u8d25", (Object)UserUtils.getTenantId(), (Object)UserUtils.getUserId());
                return deptIds;
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)((StdData)responseEntity.getBody()).getData()))) {
                deptIds = ((List)((StdData)responseEntity.getBody()).getData()).stream().map(UserDeptInfoVO::getDeptId).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u79df\u6237\u4e0b{}\u7528\u6237{}\u7684\u6240\u5c5e\u90e8\u95e8\u5931\u8d25", new Object[]{UserUtils.getTenantId(), UserUtils.getUserId(), e});
        }
        return deptIds;
    }

    @Override
    public List<EmpUserVO> getSubordinateEmpInfos(String userId, Integer level) {
        List<EmpUserVO> empUserVOS = new ArrayList<EmpUserVO>();
        if (StringUtils.isEmpty((Object)this.envProperties.getEocUri())) {
            this.logger.error("eoc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return empUserVOS;
        }
        String uri = String.format("%s/api/eoc/v2/emp/subordinate", this.envProperties.getEocUri());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("userId", userId);
        requestBody.put("level", level);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, new HttpEntity(requestBody, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<EmpUserVO>>>(){}, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful() || null == responseEntity.getBody()) {
                this.logger.error("\u83b7\u53d6\u79df\u6237\u4e0b{}\u7528\u6237{}\u7684\u76f4\u5c5e\u4e0b\u5c5e\u5931\u8d25", (Object)UserUtils.getTenantId(), (Object)UserUtils.getUserId());
                return empUserVOS;
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)((StdData)responseEntity.getBody()).getData()))) {
                empUserVOS = (List)((StdData)responseEntity.getBody()).getData();
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u79df\u6237\u4e0b{}\u7528\u6237{}\u7684\u76f4\u5c5e\u4e0b\u5c5e\u5931\u8d25", new Object[]{UserUtils.getTenantId(), UserUtils.getUserId(), e});
        }
        return empUserVOS;
    }

    @Override
    public List<TenantCompanyVO> findTenantsCompany(List<Long> tenantSids) {
        String url = this.envProperties.getEocUri() + "/api/eoc/v2/corp/company/tenants";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity requestEntity = new HttpEntity(tenantSids, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<TenantCompanyVO>>>(){}, new Object[0]);
            return (List)((StdData)responseEntity.getBody()).getData();
        }
        catch (Exception ex) {
            this.logger.error("\u6279\u91cf\u83b7\u53d6\u79df\u6237\u516c\u53f8\u4fe1\u606f", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public EmpInfoVO getEmpByCurrent(String userToken) {
        String url = String.format("%s/api/eoc/v2/emp/info/current/user", this.envProperties.getEocUri());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<EmpInfoVO>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(null);
        }
        catch (Exception ex) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7ed1\u5b9a\u5458\u5de5\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void autoEocInit(AutoEOCVO vo) {
        try {
            String uri = String.format("%s/api/eoc/v2/tenant/auto/init", this.envProperties.getEocUri());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            HttpEntity request = new HttpEntity((Object)vo, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)request, Map.class, new Object[0]);
            if (responseEntity.getBody() != null && !((Boolean)((Map)responseEntity.getBody()).get("success")).booleanValue()) {
                this.logger.error("\u8c03\u7528AutoEoc\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void bindingUserConsole(EmpUserVO empUser) {
        try {
            String uri = String.format("%s/api/eoc/v2/emp/binding/user/console", this.envProperties.getEocUri());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            HttpEntity httpEntity = new HttpEntity((Object)empUser, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, Object.class, new Object[0]);
            if (responseEntity.getBody() != null && responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logger.error(String.format("\u79df\u6237%s \u4e0b\u7528\u6237%s \u5173\u8054\u5458\u5de5%s \u5931\u8d25", empUser.getTenantSid(), empUser.getUserName(), empUser.getEmpId()));
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u79df\u6237%s \u4e0b\u7528\u6237%s \u5173\u8054\u5458\u5de5%s \u5931\u8d25", empUser.getTenantSid(), empUser.getUserName(), empUser.getEmpId()));
        }
    }

    @Override
    public void bindingUserConsoleBatch(EmpUserBO bo, String userToken) {
        String uri = this.envProperties.getEocUri() + "/api/eoc/v2/emp/binding/user/console/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity httpEntity = new HttpEntity((Object)bo, (MultiValueMap)headers);
        try {
            this.restTemplate.postForEntity(uri, (Object)httpEntity, Object.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u5173\u8054\u7528\u6237\u5458\u5de5\u5931\u8d25\uff0cuserToken = {}\uff0c empUserVOList={}", new Object[]{userToken, bo.getEmpUserVOList(), e});
        }
    }

    @Override
    public void syncAdUser(AdTenantInfoDTO dto, String userToken) {
        String url = this.envProperties.getEocUri() + TENANT_AD_USER_SYNC;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, StdData.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.logger.error("\u8c03\u7528\u3010EOC\u3011\u540c\u6b65AD\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cbody = {}", responseEntity.getBody());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u3010EOC\u3011\u540c\u6b65AD\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void syncAdOu(AdTenantInfoDTO dto, String userToken) {
        String url = this.envProperties.getEocUri() + TENANT_AD_OU_SYNC;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, StdData.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                this.logger.error("\u8c03\u7528\u3010EOC\u3011\u540c\u6b65AD\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0cbody = {}", responseEntity.getBody());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u3010EOC\u3011\u540c\u6b65AD\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

