/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.LoginInfo;
import com.digiwin.dap.middleware.commons.util.EncryptUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestCheckResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestRegisterInfo;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopSys;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.org.OrgAspectVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgResultVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgRoleTreeNode;
import com.digiwin.dap.middleware.iam.domain.org.RequestParameterVO;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.domain.role.RoleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.role.rolebean.RoleBean;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthDTO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuthVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserAllInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserBasicInfoResultVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.support.DapHttpService;
import com.digiwin.dap.middleware.util.EnvUtils;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteIamServiceImpl
implements RemoteIamService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIamServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    @Qualifier(value="noticeRestTemplate")
    @Autowired
    private RestTemplate sysNoticeRestTemplate;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private IdentityService defaultIdentityService;
    @Autowired
    private DapHttpService dapHttpService;
    @Autowired
    private DictDataService dictDataService;
    private static final String INTEGRATION_USERNAME = "integration";
    private static final String INTEGRATION_PASSWORD = "integration";
    private static final String DEV_APP_ID_EXISTED = "%s/api/iam/v2/dev/app/id/%s/existed";
    private static final String TENANT_AUTH = "/api/iam/v2/tenant/auth";
    private static final Map<DeployAreaEnum, DeployAreaEnum> IamDeployAreaMapping = new HashMap<DeployAreaEnum, DeployAreaEnum>();

    @Override
    public Object registerTestTenant(DevTestRegisterInfo devTestRegisterInfo) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getIamTestUri())) {
            String uri = String.format("%s/api/iam/v2/dev/test/env/register/tenant", this.envProperties.getIamTestUri());
            HttpEntity httpEntity = new HttpEntity((Object)devTestRegisterInfo);
            try {
                StdData data = (StdData)this.restTemplate.postForObject(uri, (Object)httpEntity, StdData.class, new Object[0]);
                if (null != data && 200 == data.getCode()) {
                    return data.getData();
                }
                throw new BusinessException((ErrorHandler)I18nError.CREATE_TEST_TENANT_FAILED, new Object[]{uri, JsonUtils.createObjectMapper().writeValueAsString((Object)devTestRegisterInfo), data != null ? data.getMessage() : null});
            }
            catch (Exception exception) {
                throw new BusinessException((ErrorHandler)I18nError.CREATE_TEST_TENANT_FAILED, new Object[]{uri, devTestRegisterInfo.getAppId()});
            }
        }
        throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
    }

    @Override
    public Object existTestApps(String tenantId, DevTestCheckResultVO checkRequest) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getIamTestUri())) {
            String uri = String.format("%s/api/iam/v2/dev/test/env/exists/tenant/apps/test", this.envProperties.getIamTestUri());
            checkRequest.setTenantId(tenantId);
            HttpEntity httpEntity = new HttpEntity((Object)checkRequest);
            try {
                StdData data = (StdData)this.dapRetryRestTemplate.postForObject(uri, (Object)httpEntity, StdData.class, new Object[0]);
                if (null != data && 200 == data.getCode()) {
                    return data.getData();
                }
                throw new BusinessException((ErrorHandler)I18nError.CREATE_TEST_TENANT_FAILED, new Object[]{uri, JsonUtils.createObjectMapper().writeValueAsString((Object)checkRequest), data != null ? data.getMessage() : null});
            }
            catch (Exception exception) {
                throw new BusinessException((ErrorHandler)I18nError.CREATE_TEST_TENANT_FAILED, new Object[]{uri, checkRequest.getApps(), exception.getMessage()});
            }
        }
        throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
    }

    @Override
    public boolean existsDevAppById(String id, DeployAreaEnum deployAreaEnum) {
        HttpHeaders headers = new HttpHeaders();
        String userToken = this.getUserToken(this.envProperties.getManagerTenant(), deployAreaEnum);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = String.format(DEV_APP_ID_EXISTED, EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum), id);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<Boolean>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(Boolean.FALSE);
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.logError((String)"\u3010IAM\u8c03\u7528\u3011 \u68c0\u67e5dev\u5e94\u7528\u662f\u5426\u5b58\u5728\u5931\u8d25", (String)url, (Object)request.getBody(), (Exception)e), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.CHECK_DEV_SYS_FAILED);
        }
    }

    @Override
    public String getUserToken(String tenantId, DeployAreaEnum deployAreaEnum) {
        return this.dapHttpService.getUserToken(tenantId, EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum));
    }

    @Override
    public AuthoredUser getUserInfo(String userToken, DeployAreaEnum deployAreaEnum) {
        String uri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum) + "/api/iam/v2/identity/token/analyze";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, LoginInfo.class, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(loginInfo -> {
                loginInfo.setToken(userToken);
                return loginInfo.getAuthoredUser();
            }).orElse(null);
        }
        catch (Exception e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, uri, e);
        }
    }

    @Override
    public String getUserToken(String tenantId) {
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType("integration", "integration", "integration", 0);
        LoginUser loginUser = new LoginUser();
        loginUser.setTenantId(tenantId);
        loginUser.setUserId("integration");
        loginUser.setPassword("integration");
        loginUser.setIdentityType(IdentityType.token);
        loginUser.setUser(user);
        IamAuthoredUser login = this.defaultIdentityService.login(loginUser);
        if (login != null) {
            return login.getToken();
        }
        return null;
    }

    @Override
    public List<TenantAuthVO> getTenantAuthInfos(TenantAuthDTO tenantAuthDTO, DeployAreaEnum deployAreaEnum) {
        HttpHeaders headers = new HttpHeaders();
        HttpEntity request = new HttpEntity((Object)tenantAuthDTO, (MultiValueMap)headers);
        String url = String.format("%s%s", EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum), TENANT_AUTH);
        try {
            ResponseEntity result = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<TenantAuthVO>>>(){}, new Object[0]);
            return Optional.ofNullable(result.getBody()).map(StdData::getData).orElseGet(Collections::emptyList);
        }
        catch (Exception ex) {
            LOGGER.error("\u83b7\u53d6{}\u7684\u79df\u6237\u6388\u6743\u5931\u8d25", (Object)deployAreaEnum, (Object)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public IamAuthoredUser crossRegionLogin(String cloud, String area, String tenantId, String sysId, String customerId) {
        String iamUrl;
        DeployAreaEnum deployAreaEnum = DeployAreaEnum.get((String)cloud, (String)area);
        if (Objects.isNull(deployAreaEnum)) {
            DictDataDTO dictDataDTO = new DictDataDTO();
            dictDataDTO.setDictId("DeployArea");
            dictDataDTO.setDictKey(cloud + "_" + area);
            DictData dictData = this.dictDataService.selectDictData(dictDataDTO);
            if (Objects.isNull(dictData)) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_DEPLOY_AREA_NOT_CONFIG);
            }
            iamUrl = dictData.getDictValue();
        } else {
            if (IamDeployAreaMapping.containsKey(deployAreaEnum)) {
                deployAreaEnum = IamDeployAreaMapping.get(deployAreaEnum);
            }
            iamUrl = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum);
        }
        String crossRegionLoginUri = iamUrl + "/api/iam/v2/identity/cross/region/login/inner";
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("sysId", sysId);
        requestMap.put("customerId", customerId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-middleware-sign-arg", EncryptUtils.sign((String)this.envProperties.getAppSecret(), null, requestMap));
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(crossRegionLoginUri, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<IamAuthoredUser>>(){}, new Object[0]);
            StdData authoredUserStdData = (StdData)responseEntity.getBody();
            if (null == authoredUserStdData) {
                LOGGER.error("\u8de8\u533a\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7Token\u5931\u8d25, iamUri:{}", (Object)crossRegionLoginUri);
                throw new BusinessException((ErrorHandler)I18nError.IAM_ACCESS_CROSS_REGION_ERROR);
            }
            if (!authoredUserStdData.getSuccess().booleanValue()) {
                LOGGER.error("\u8de8\u533a\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7Token\u5931\u8d25, iamUri:{}, resp:{}", (Object)crossRegionLoginUri, (Object)JsonUtils.objToJson((Object)authoredUserStdData));
                throw new BusinessException(authoredUserStdData.getMessage());
            }
            return (IamAuthoredUser)authoredUserStdData.getData();
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u8de8\u533a\u83b7\u53d6IAM\u96c6\u6210\u8d26\u53f7Token\u5931\u8d25, iamUri:{}", (Object)crossRegionLoginUri, (Object)e);
            throw new BusinessException((ErrorHandler)I18nError.IAM_ACCESS_CROSS_REGION_ERROR);
        }
    }

    @Override
    public UserBasicInfoResultVO queryUserAllInformationWithPage(QueryUserAllInfoVO body, String userToken, DeployAreaEnum deployAreaEnum) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        String url = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum) + "/api/iam/v2/query/user/allinfo";
        try {
            ResponseEntity responseEntity = this.sysNoticeRestTemplate.postForEntity(url, (Object)request, UserBasicInfoResultVO.class, new Object[0]);
            return (UserBasicInfoResultVO)responseEntity.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u67e5\u8be2\u5f53\u524d\u79df\u6237\u4e0b\u7684\u7528\u6237\u57fa\u672c\u4fe1\u606f[\u5206\u9875]\u3011\u5931\u8d25, userToken={}, deployAreaEnum={}", (Object[])new Object[]{userToken, deployAreaEnum}), (Throwable)ex);
        }
    }

    @Override
    public List<RoleQueryResultVO> getRoleInCatalog(RoleBean roleBean, String userToken, DeployAreaEnum deployAreaEnum) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)roleBean, (MultiValueMap)headers);
        String url = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum) + "/api/iam/v2/role/query";
        try {
            ResponseEntity result = this.sysNoticeRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<RoleQueryResultVO>>(){}, new Object[0]);
            return (List)result.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u6839\u636e\u662f\u5426\u7981\u7528\u53d6\u5f97\u79df\u6237\u4e0b\u7684\u89d2\u8272\u3011\u5931\u8d25, userToken={}, deployAreaEnum={}", (Object[])new Object[]{userToken, deployAreaEnum}), (Throwable)ex);
        }
    }

    @Override
    public List<OrgResultVO> getOrgAspect(OrgAspectVO orgAspectVO, String userToken, DeployAreaEnum deployAreaEnum) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)orgAspectVO, (MultiValueMap)headers);
        String url = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)deployAreaEnum) + "/api/iam/v2/org/aspect";
        try {
            ResponseEntity responseEntity = this.sysNoticeRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<OrgResultVO>>(){}, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u53d6\u5f97\u7ec4\u7ec7\u6811\u72b6\u7ed3\u6784\u3011\u5931\u8d25, userToken={}, deployAreaEnum={}", (Object[])new Object[]{userToken, deployAreaEnum}), (Throwable)ex);
        }
    }

    @Override
    public List<TenantApplication> getUserApplicationByTenant(String iamUri, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = iamUri + "/api/iam/v2/user/tenant/application" + "?showConsoleManagement=true";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<TenantApplication>>(){}, new Object[0]);
            return (List)responseEntity.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u67e5\u8be2\u79df\u6237\u4e0b\u7684\u5e94\u7528\u6e05\u5355\u3011\u5931\u8d25, userToken={}, iamUrl={}", (Object[])new Object[]{userToken, iamUri}), (Throwable)ex);
        }
    }

    @Override
    public SysCascade getApp(RequestParameterVO requestParameterVO, String iamUri, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((Object)requestParameterVO, (MultiValueMap)headers);
        String url = iamUri + "/api/iam/v2/app";
        try {
            ResponseEntity responseEntity = this.sysNoticeRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<SysCascade>(){}, new Object[0]);
            return (SysCascade)responseEntity.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u83b7\u53d6\u6307\u5b9aapp\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u5305\u62ec\u5e94\u7528\u3001\u6a21\u7ec4\u3001\u884c\u4e3a\u548c\u6761\u4ef6\u7b49\u4fe1\u606f\u3011\u5931\u8d25, userToken={}, iamUrl={}", (Object[])new Object[]{userToken, iamUri}), (Throwable)ex);
        }
    }

    @Override
    public Map<Long, String> getAction(TargetPolicy input, String iamUri, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((Object)input, (MultiValueMap)headers);
        String url = iamUri + "/api/iam/v2/policy/action/actual";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<Map<Long, String>>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElseGet(Collections::emptyMap);
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u83b7\u53d6\u76ee\u6807\u5b9e\u9645\u8bbe\u5b9a\u7684\u6743\u9650\uff0c\u4e0d\u662f\u5408\u5e76\u7ed3\u679c\u3011\u5931\u8d25, userToken={}, iamUrl={}", (Object[])new Object[]{userToken, iamUri}), (Throwable)ex);
        }
    }

    @Override
    public Map<String, List<OrgRoleTreeNode>> getOrgCascadeInTenant(String iamUri, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = iamUri + "/api/iam/v2/org/cascade";
        try {
            ResponseEntity responseEntity = this.sysNoticeRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, List<OrgRoleTreeNode>>>(){}, new Object[0]);
            return (Map)responseEntity.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4e0b\u5168\u90e8\u7ec4\u7ec7\u548c\u5b50\u7ec4\u7ec7\u3011\u5931\u8d25, userToken={}, iamUrl={}", (Object[])new Object[]{userToken, iamUri}), (Throwable)ex);
        }
    }

    @Override
    public TargetPolicy getPolicyActionCondition(TargetPolicy remoteConditionInput, String iamUri, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((Object)remoteConditionInput, (MultiValueMap)headers);
        String url = iamUri + "/api/iam/v2/policy/query/action/condition";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<TargetPolicy>(){}, new Object[0]);
            return (TargetPolicy)responseEntity.getBody();
        }
        catch (Exception ex) {
            throw new BusinessException(CharSequenceUtil.format((CharSequence)"\u3010\u67e5\u8be2\u76ee\u6807\u884c\u4e3a\u72b6\u6001\u3011\u5931\u8d25, userToken={}, iamUrl={}", (Object[])new Object[]{userToken, iamUri}), (Throwable)ex);
        }
    }

    @Override
    public List<DevelopSys> getDevSysOrByCustomer(String customerId, DeployAreaEnum area) {
        String iamUri = EnvUtils.getUri((CommonCode)CommonCode.IAM, (DeployAreaEnum)area);
        String url = String.format("%s%s?customerId=%s", iamUri, "/api/iam/v2/dev/app/tenant/customer", customerId);
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, this.dapHttpService.getUserToken(this.envProperties.getManagerTenant(), iamUri));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<DevelopSys>>>(){}, new Object[0]);
        if (null != result && null != result.getBody()) {
            return (List)((StdData)result.getBody()).getData();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean existsTenantById(String iamUri, String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, null);
        HttpEntity request = new HttpEntity(Collections.singletonMap("id", tenantId), (MultiValueMap)headers);
        String url = iamUri + "/api/iam/v2/tenant/exists";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Boolean>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(x -> (Boolean)x.get("isExistId")).orElse(false);
        }
        catch (Exception ex) {
            throw new BusinessException(String.format("\u3010\u5224\u65ad\u79df\u6237\u662f\u5426\u5b58\u5728\u3011\u5931\u8d25, iamUrl=%s", iamUri), (Throwable)ex);
        }
    }

    static {
        IamDeployAreaMapping.put(DeployAreaEnum.HuaweiTest, DeployAreaEnum.AliyunTest);
        IamDeployAreaMapping.put(DeployAreaEnum.HuaweiProd, DeployAreaEnum.AliyunProd);
    }
}

