/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import cn.hutool.extra.servlet.ServletUtil;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.changelog.ChangeLogDO;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.internal.BusinessTypeEnum;
import com.digiwin.dap.middleware.lmc.internal.model.entity.ChangeInfo;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLog;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.digiwin.dap.middleware.lmc.request.SaveOpLog;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.NetUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class RemoteLMCServiceImpl
implements RemoteLMCService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteLMCServiceImpl.class);
    private static final String DIGIWIN_TENANT_ID = "99990000";
    private static final String CHANGE_LOGS_RESULT = "/api/lmc/v1/buckets/digiwincloud/changelogs/result";
    private static final String CHANGE_LOGS_NEW_RESULT = "/api/lmc/v1/oplog";
    private static final String BATCH_CHANGE_LOGS_NEW_RESULT = "/api/lmc/v1/oplog/batch";
    private static final String LMC_OPLOG_COMPARE_DIRECT = "/api/lmc/v1/oplog/compare/direct";
    @Autowired
    private LMC lmcClient;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RemoteIamService remoteIamService;
    @Qualifier(value="dapLogExecutor")
    @Autowired
    private ThreadPoolTaskExecutor dapLogExecutor;

    @Override
    public void saveChangeLogCore(ChangeLogDO changeLogDO) {
        this.saveChangeLog(changeLogDO, CHANGE_LOGS_RESULT);
    }

    @Override
    public void saveNewChangeLog(ChangeLogDO changeLogDO) {
        this.saveChangeLog(changeLogDO, CHANGE_LOGS_NEW_RESULT);
    }

    @Override
    public void batchSaveChangeLog(List<ChangeLogDO> changeLogDOS) {
        this.saveChangeLog(changeLogDOS, BATCH_CHANGE_LOGS_NEW_RESULT);
    }

    @Override
    public void saveAgreeAgreementChangeLog(AuthoredSys authoredSys, AuthoredUser authoredUser, Boolean agreeAgreement) {
        if (!Boolean.TRUE.equals(agreeAgreement)) {
            return;
        }
        SaveOpLog saveOpLog = new SaveOpLog();
        String appId = Optional.ofNullable(authoredSys).map(AuthoredSys::getId).map(x -> "DigiwinCloud".equalsIgnoreCase((String)x) ? x.toLowerCase() : x).orElse("DigiwinCloud".toLowerCase());
        saveOpLog.setAppId(appId);
        saveOpLog.setModuleId("default");
        saveOpLog.setActId("default");
        saveOpLog.setOperationType("insert");
        saveOpLog.setSource("iam");
        saveOpLog.setActionId("user.agreement");
        saveOpLog.setPrimaryKey(authoredUser.getUserId());
        saveOpLog.setPrimaryName(authoredUser.getUserName());
        saveOpLog.setEditUserId(authoredUser.getUserId());
        saveOpLog.setEditUserName(authoredUser.getUserName());
        String editPlace = "dev".equals(appId) ? "devConsole" : ("ISV".equals(appId) ? "ISV".toLowerCase() : "console");
        saveOpLog.setEditPlace(editPlace);
        saveOpLog.setRemark("");
        saveOpLog.setOperationObject(String.format("%s(%s)", authoredUser.getUserName(), authoredUser.getUserId()));
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey("agreeAgreement");
        changeInfo.setDisplayName("\u7528\u6237\u5408\u7ea6\u540c\u610f");
        changeInfo.setModifyValue(Boolean.TRUE.toString());
        changeInfo.setOriginValue("");
        changeInfo.setInsertInfo(this.getInsertInfo());
        saveOpLog.setChangeInfoList(Collections.singletonList(changeInfo));
        this.saveChangeLogCore(saveOpLog, authoredUser.getToken());
    }

    @Override
    public void saveAgreeCertificationAgreementChangeLog(Tenant tenant, AuthoredUser authoredUser, String appId, Boolean agreeCertificationAgreement) {
        if (!Boolean.TRUE.equals(agreeCertificationAgreement)) {
            return;
        }
        SaveOpLog saveOpLog = new SaveOpLog();
        saveOpLog.setAppId(appId);
        saveOpLog.setModuleId("default");
        saveOpLog.setActId("default");
        saveOpLog.setOperationType("insert");
        saveOpLog.setSource("iam");
        saveOpLog.setActionId("tenant.privacy");
        saveOpLog.setPrimaryKey(tenant.getId());
        saveOpLog.setPrimaryName(tenant.getName());
        saveOpLog.setEditUserId(authoredUser.getUserId());
        saveOpLog.setEditUserName(authoredUser.getUserName());
        String editPlace = "dev".equals(appId) ? "devConsole" : ("ISV".equals(appId) ? "ISV".toLowerCase() : "console");
        saveOpLog.setEditPlace(editPlace);
        saveOpLog.setRemark("");
        saveOpLog.setOperationObject(String.format("%s(%s)", tenant.getName(), tenant.getId()));
        saveOpLog.setTenantId(tenant.getId());
        saveOpLog.setTenantName(tenant.getName());
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setKey("agreeCertificationAgreement");
        changeInfo.setDisplayName("\u9690\u79c1\u6743\u540c\u610f");
        changeInfo.setModifyValue(Boolean.TRUE.toString());
        changeInfo.setOriginValue("");
        changeInfo.setInsertInfo(this.getInsertInfo());
        saveOpLog.setChangeInfoList(Collections.singletonList(changeInfo));
        this.saveChangeLogCore(saveOpLog, authoredUser.getToken());
    }

    private void saveChangeLog(Object changeLogDO, String uri) {
        if (StringUtils.isEmpty((Object)this.envProperties.getLmcUri())) {
            logger.error("\u3010LMC\u3011 \u8fde\u63a5\u5730\u5740\u4e3a\u7a7a");
            return;
        }
        String userToken = StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(DIGIWIN_TENANT_ID) : UserUtils.getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "application/json;charset=UTF-8");
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity logRequest = new HttpEntity(changeLogDO, (MultiValueMap)headers);
        String url = this.envProperties.getLmcUri() + uri;
        this.dapLogExecutor.execute(() -> this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]));
    }

    @Override
    public void saveChangeLogCore(SaveOpLog saveOpLog, String userToken) {
        this.dapLogExecutor.execute(() -> {
            try {
                this.lmcClient.saveOpLog(saveOpLog, userToken);
            }
            catch (Exception e) {
                logger.error("\u3010LMC\u8c03\u7528\u3011\u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
            }
        });
    }

    @Override
    @Async(value="dapLogExecutor")
    public void addLogoutLog(AuthoredUser authoredUser, String appId, String ip, boolean clearAll) {
        try {
            SaveEventLog eventLog = new SaveEventLog();
            if (StringUtils.isEmpty((Object)appId)) {
                eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u51fa\u6210\u529f\uff01", authoredUser.getUserName(), authoredUser.getUserId()));
            } else {
                eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u51fa\u5e94\u7528[%s]\u6210\u529f\uff01", authoredUser.getUserName(), authoredUser.getUserId(), appId));
            }
            eventLog.setEventType(BusinessTypeEnum.LOGOUT.getValue());
            eventLog.setTenantId(authoredUser.getTenantId());
            eventLog.setTenantName(authoredUser.getTenantName());
            eventLog.setSysId(appId);
            eventLog.setUserId(authoredUser.getUserId());
            eventLog.setUserName(authoredUser.getUserName());
            eventLog.setIp("0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip);
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("userToken", authoredUser.getToken());
            content.put("clearAll", clearAll);
            eventLog.setContent(content);
            this.lmcClient.saveEventLog(eventLog);
        }
        catch (Exception e) {
            logger.error("lmc\u8bb0\u5f55\u767b\u51fa\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @Async(value="dapLogExecutor")
    public void addLoginLog(LoginUser loginUser, String ip, String userToken, String agentUserId) {
        String key;
        boolean exists;
        if (loginUser == null) {
            return;
        }
        User user = loginUser.getUser();
        if (user == null) {
            return;
        }
        String userId = user.getId();
        String userName = user.getName();
        Tenant tenant = loginUser.getTenant();
        String tenantId = "";
        String tenantName = "";
        if (tenant != null) {
            tenantId = tenant.getId();
            tenantName = tenant.getName();
        }
        Sys sys = loginUser.getApp();
        String appId = "";
        if (sys != null) {
            appId = sys.getId();
        }
        if (!(exists = RedisUtils.setIfAbsent((String)(key = String.format("iam:user:login:history:%s:%s:%s:%s", tenantId, userId, appId, BusinessTypeEnum.LOGIN.getDescribe())), (Object)1, (Duration)Duration.ofSeconds(30L)))) {
            return;
        }
        try {
            SaveEventLog eventLog = new SaveEventLog();
            if (StringUtils.isEmpty((Object)appId)) {
                eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u5165\u6210\u529f\uff01", userName, userId));
            } else {
                eventLog.setEventName(String.format("\u7528\u6237[%s(%s)]\uff0c\u767b\u5165\u5e94\u7528[%s]\u6210\u529f\uff01", userName, userId, appId));
            }
            eventLog.setEventType(BusinessTypeEnum.LOGIN.getValue());
            eventLog.setTenantId(tenantId);
            eventLog.setTenantName(tenantName);
            eventLog.setSysId(appId);
            eventLog.setUserId(userId);
            eventLog.setUserName(userName);
            eventLog.setIp("0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip);
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("identityType", (Object)loginUser.getIdentityType());
            content.put("serviceName", loginUser.getServiceName());
            content.put("userToken", userToken);
            content.put("Gclid", loginUser.getGclid());
            if (Objects.nonNull(loginUser.getDevice())) {
                content.put("deviceKey", loginUser.getDevice().getDeviceKey());
                content.put("sourceType", loginUser.getDevice().getSourceType());
                content.put("deviceId", loginUser.getDevice().getDeviceId());
                content.put("deviceTypeDetail", loginUser.getDevice().getDeviceTypeDetail());
            }
            if (Objects.nonNull(loginUser.getDeviceType())) {
                content.put("deviceType", loginUser.getDeviceType().name());
            }
            if (!StringUtils.isEmpty((Object)agentUserId)) {
                content.put("agentUserId", agentUserId);
            }
            eventLog.setContent(content);
            this.lmcClient.saveEventLog(eventLog);
        }
        catch (Exception e) {
            logger.error("lmc\u8bb0\u5f55\u767b\u5165\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, Object> getInsertInfo() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        Map headerMap = ServletUtil.getHeaderMap((HttpServletRequest)request);
        HashMap<String, Object> insertInfo = new HashMap<String, Object>(headerMap);
        insertInfo.put("ip", ServletUtil.getClientIPByHeader((HttpServletRequest)request, (String[])NetUtils.HEADERS));
        return insertInfo;
    }

    @Override
    public void updateDevSysLog(DevSys before, DevSys after) {
        try {
            Field[] fields;
            SaveCompareOpLog dto = new SaveCompareOpLog();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            dto.setActId("MMC");
            dto.setSource("MMC");
            dto.setActionId(BusinessTypeEnum.UPDATE.getDescribe());
            dto.setTableName("goods");
            dto.setModuleId(request.getServletPath());
            dto.setEditUserId(UserUtils.getUserId());
            dto.setEditUserName(UserUtils.getUserName());
            dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
            ArrayList<Map<String, String>> logFieldList = new ArrayList<Map<String, String>>();
            dto.setLogFieldList(logFieldList);
            for (Field field : fields = ((Object)((Object)after)).getClass().getDeclaredFields()) {
                logFieldList.add(this.getDisplayMap(field.getName(), field.getName()));
            }
            ArrayList primaryKeyList = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", "");
            map.put("keyName", "id");
            primaryKeyList.add(map);
            dto.setPrimaryKeyList(primaryKeyList);
            dto.setAppId("MMC");
            dto.setPrimaryKey(String.valueOf(after.getSid()));
            dto.setModifyJson(new HashMap(JsonUtils.objToMap((Object)((Object)after))));
            dto.setOriginJson(new HashMap(JsonUtils.objToMap((Object)((Object)before))));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json;charset=UTF-8");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity logRequest = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String url = this.envProperties.getLmcUri() + LMC_OPLOG_COMPARE_DIRECT;
            this.restTemplate.postForEntity(url, (Object)logRequest, Object.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void insertDevSysLog(DevSys devSys) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setSource("MMC");
            changeLogDO.setActionId("tenant.userEnabled");
            changeLogDO.setOperationType("insert");
            changeLogDO.setPrimaryKey(String.valueOf(devSys.getSid()));
            changeLogDO.setEditUserId(StringUtils.isEmpty((Object)UserUtils.getUserId()) ? "" : UserUtils.getUserId());
            changeLogDO.setEditPlace("devConsole");
            changeLogDO.setEditTime(LocalDateTime.now());
            changeLogDO.setEditUserId(UserUtils.getUserId());
            changeLogDO.setEditUserName(StringUtils.isEmpty((Object)UserUtils.getUserName()) ? "" : UserUtils.getUserName());
            changeLogDO.setModuleId("MMC");
            changeLogDO.setActId(devSys.getId());
            changeLogDO.setAppId("MMC");
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            changeLogDO.setChangeInfoList(changeInfoList);
            BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)devSys)).getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                Object value = propertyDescriptor.getReadMethod().invoke((Object)devSys, new Object[0]);
                if (value == null) continue;
                changeInfoList.add(this.getChangeInfo(name, value));
            }
            this.saveNewChangeLog(changeLogDO);
        }
        catch (Exception e) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, String> getDisplayMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fieldName", key);
        map.put("displayName", value);
        return map;
    }

    private Map<String, Object> getChangeInfo(String name, Object modifyValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", name);
        map.put("modifyValue", modifyValue);
        return map;
    }

    @Override
    public void updateCompareChangeLog(String actionId, Object before, Object after, String primaryKey, List<String> primaryKeyFields, List<Map<String, String>> logFieldList, Map<String, Object> otherInfo) {
        try {
            SaveCompareOpLog dto = new SaveCompareOpLog();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            dto.setActId(actionId);
            dto.setAppId("IAM");
            dto.setSource("IAM");
            dto.setActionId(actionId);
            dto.setModuleId(request.getServletPath());
            dto.setEditUserId(UserUtils.getUserId());
            dto.setEditUserName(UserUtils.getUserName());
            dto.setOperationType(BusinessTypeEnum.UPDATE.getDescribe());
            dto.setContent(otherInfo);
            dto.setPrimaryKey(primaryKey);
            if (CollectionUtils.isEmpty(logFieldList)) {
                Field[] fields;
                for (Field field : fields = after.getClass().getDeclaredFields()) {
                    logFieldList.add(this.getDisplayMap(field.getName(), field.getName()));
                }
            }
            dto.setLogFieldList(logFieldList);
            ArrayList primaryKeyList = new ArrayList();
            primaryKeyFields.forEach(f -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", "");
                map.put("keyName", (String)f);
                primaryKeyList.add(map);
            });
            dto.setPrimaryKeyList(primaryKeyList);
            dto.setModifyJson((Map)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)after), Map.class));
            dto.setOriginJson((Map)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)before), Map.class));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Accept", "application/json;charset=UTF-8");
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            this.saveCompareOpLogDirect(dto, UserUtils.getToken());
        }
        catch (Exception e) {
            logger.error("\u3010LMC\u8c03\u7528\u3011 \u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void updateCompareChangeLog(String actionId, Object before, Object after, String primaryKey, List<String> primaryKeyFields, List<Map<String, String>> logFieldList) {
        this.updateCompareChangeLog(actionId, before, after, primaryKey, primaryKeyFields, logFieldList, new HashMap<String, Object>());
    }

    @Override
    public void createChangeLog(String actionId, Object data, String primaryKey, String primaryKeyValue) {
        SaveOpLog saveOpLog = new SaveOpLog();
        saveOpLog.setAppId("IAM");
        saveOpLog.setModuleId("IAM");
        saveOpLog.setActId(actionId);
        saveOpLog.setOperationType("insert");
        saveOpLog.setSource(UserUtils.getSysId());
        saveOpLog.setActionId(actionId);
        saveOpLog.setPrimaryKey(UserUtils.getUserId());
        saveOpLog.setPrimaryName(UserUtils.getUserName());
        saveOpLog.setEditUserId(UserUtils.getUserId());
        saveOpLog.setEditUserName(UserUtils.getUserName());
        saveOpLog.setEditPlace(UserUtils.getSysId());
        saveOpLog.setPrimaryKey(primaryKeyValue);
        saveOpLog.setPrimaryName(primaryKey);
        ChangeInfo changeInfo = new ChangeInfo();
        changeInfo.setInsertInfo((Map)JsonUtils.jsonToObj((String)JsonUtils.objToJson((Object)data), Map.class));
        saveOpLog.setChangeInfoList(Collections.singletonList(changeInfo));
        this.saveOpLog(saveOpLog, UserUtils.getToken());
    }

    private void saveCompareOpLogDirect(SaveCompareOpLog saveOpLog, String userToken) {
        this.dapLogExecutor.execute(() -> {
            try {
                this.lmcClient.saveCompareOpLogDirect(saveOpLog, userToken);
            }
            catch (Exception e) {
                logger.error("\u3010LMC\u8c03\u7528\u3011\u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private void saveOpLog(SaveOpLog changeLogDO, String userToken) {
        this.dapLogExecutor.execute(() -> {
            try {
                this.lmcClient.saveOpLog(changeLogDO, userToken);
            }
            catch (Exception e) {
                logger.error("\u3010LMC\u8c03\u7528\u3011\u4fdd\u5b58\u53d8\u66f4\u5386\u7a0b\u5931\u8d25", (Throwable)e);
            }
        });
    }
}

