/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.support.remote.ServiceCloudRemoteService;
import com.digiwin.dap.middleware.iam.support.remote.domain.WechatAuthorizeResponse;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ServiceCloudRemoteServiceImpl
implements ServiceCloudRemoteService {
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public String getOpenId(String tokenSeed) {
        String url = String.format("%s?tokenSeed=%s", this.envProperties.getWechatVerifyUrl(), tokenSeed);
        try {
            WechatAuthorizeResponse wechatAuthorizeResponse = (WechatAuthorizeResponse)this.restTemplate.getForObject(url, WechatAuthorizeResponse.class, new Object[0]);
            if (null == wechatAuthorizeResponse || !Boolean.TRUE.equals(wechatAuthorizeResponse.getConfirmed()) || null == wechatAuthorizeResponse.getData()) {
                throw new BusinessException((ErrorHandler)I18nError.WECHAT_AUTHORIZATION_FAILED);
            }
            LinkedHashMap result = (LinkedHashMap)JsonUtils.createObjectMapper().readValue(wechatAuthorizeResponse.getData().toString(), LinkedHashMap.class);
            if (null == result || null == result.get("openid")) {
                throw new BusinessException((ErrorHandler)I18nError.WECHAT_AUTHORIZATION_FAILED_NO_OPEN_ID);
            }
            return result.get("openid").toString();
        }
        catch (Exception ex) {
            throw new BusinessException((ErrorHandler)I18nError.WECHAT_AUTHORIZATION_FAILED);
        }
    }
}

