/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.oauth.impl;

import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.OauthLoginRequest;
import com.digiwin.dap.middleware.iam.support.remote.domain.RespondCommonResult;
import com.digiwin.dap.middleware.iam.support.remote.oauth.RemoteOauthService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="dingTalkOauthService")
public class DingTalkOauthServiceImpl
implements RemoteOauthService {
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public boolean support(String type) {
        return ComeFromEnum.DINGDING.getId().equals(type);
    }

    @Override
    public OauthLoginRequest getUserInfo(String url, String method, String accessToken, Object data) {
        OauthLoginRequest result;
        block3: {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("access_token", accessToken);
            HttpEntity request = data != null ? new HttpEntity(data, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
            result = new OauthLoginRequest();
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.valueOf((String)method), request, RespondCommonResult.class, new Object[0]);
                RespondCommonResult entityBody = (RespondCommonResult)responseEntity.getBody();
                if (responseEntity.getStatusCode() != HttpStatus.OK || entityBody == null) break block3;
                if (entityBody.getErrcode() == 0) {
                    Map resultData = (Map)entityBody.getResult();
                    result.setUnionid((String)resultData.get("unionid"));
                    break block3;
                }
                throw new BusinessException((ErrorHandler)I18nError.TOKEN_ADDRESS_ERROR, new Object[]{url, accessToken});
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.TOKEN_ADDRESS_ERROR, new Object[]{url, accessToken});
            }
        }
        return result;
    }
}

