/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.oauth.impl;

import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.OauthLoginRequest;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComResponseResult;
import com.digiwin.dap.middleware.iam.support.remote.oauth.RemoteOauthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service(value="weComOauthService")
public class WeComOauthServiceImpl
implements RemoteOauthService {
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public boolean support(String type) {
        return ComeFromEnum.WECOM.getId().equals(type);
    }

    @Override
    public OauthLoginRequest getUserInfo(String url, String method, String accessToken, Object data) {
        OauthLoginRequest result;
        block4: {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("access_token", accessToken);
            HttpEntity request = data != null ? new HttpEntity(data, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
            result = new OauthLoginRequest();
            try {
                ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.valueOf((String)method), request, WeComResponseResult.class, new Object[0]);
                WeComResponseResult entityBody = (WeComResponseResult)responseEntity.getBody();
                if (responseEntity.getStatusCode() != HttpStatus.OK || entityBody == null) break block4;
                if (entityBody.getErrcode() == 0) {
                    if (!StringUtils.isEmpty((Object)entityBody.getMobile())) {
                        result.setUnionid(entityBody.getMobile());
                        break block4;
                    }
                    throw new BusinessException((ErrorHandler)I18nError.TOKEN_ADDRESS_ERROR, new Object[]{url, accessToken});
                }
                throw new BusinessException((ErrorHandler)I18nError.TOKEN_ADDRESS_ERROR, new Object[]{url, accessToken});
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.TOKEN_ADDRESS_ERROR, new Object[]{url, accessToken});
            }
        }
        return result;
    }
}

