/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.stream.producer.impl;

import com.digiwin.dap.middle.stream.producer.channel.KanbanOutput;
import com.digiwin.dap.middleware.iam.support.stream.producer.KanBanProducerService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class KanBanProducerServiceImpl
implements KanBanProducerService {
    private static final Logger logger = LoggerFactory.getLogger(KanBanProducerServiceImpl.class);
    @Autowired
    private KanbanOutput channel;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;

    @Override
    public void sendUserInfoToKanBan(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        try {
            String json = JsonUtils.createObjectMapper().writeValueAsString(map);
            Message message = MessageBuilder.withPayload((Object)json).setHeader("Accept-Language", (Object)LocaleContextHolder.getLocale().toLanguageTag()).build();
            this.dapTaskExecutor.execute(() -> this.channel.kanban().send(message));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

