/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.validate.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTargetVO;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthAppResultVO;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.util.RedisUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class AuthValidateServiceImpl
implements AuthValidateService {
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RamService ramService;
    @Autowired
    private SysCrudService sysCrudService;

    @Override
    public CalcUser checkPermission(UserPermissionVO input, IamAuthoredUser authoredUser, Sys loginSys) {
        return this.checkPermission(input, authoredUser, loginSys, true);
    }

    @Override
    public CalcUser checkPermission(UserPermissionVO input, IamAuthoredUser authoredUser, Sys loginSys, Boolean checkUserAuth) {
        if (input == null) {
            input = new UserPermissionVO();
        }
        if (StringUtils.isEmpty((Object)input.getTarget()) && loginSys != null) {
            input.setTarget("drn:iam:app:" + loginSys.getId());
        }
        if (StringUtils.isEmpty((Object)input.getUserId())) {
            input.setUserId(authoredUser.getUserId());
        }
        Assert.notNull((Object)input, (String)"input \u4e0d\u80fd\u4e3anull");
        Assert.notNull((Object)input.getUserId(), (String)"input.userId \u4e0d\u80fd\u4e3anull");
        Assert.notNull((Object)input.getTarget(), (String)"input.target \u4e0d\u80fd\u4e3anull");
        String[] splitTarget = input.getTarget().split(":");
        if (splitTarget.length < 4) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_URI_ERROR, new Object[]{input.getTarget()});
        }
        input.setSysId(splitTarget[3]);
        CalcUser calcUser = new CalcUser();
        if (StrUtils.isEmpty((String)input.getTenantId())) {
            if (authoredUser.getTenantSid() == 0L) {
                throw new BusinessException((ErrorHandler)I18nError.PERMISSION_USER_NO_TENANT, new Object[]{calcUser.getUserId()});
            }
            calcUser.setTenantSid(authoredUser.getTenantSid());
            calcUser.setTenantId(authoredUser.getTenantId());
        } else {
            if (!authoredUser.getTenantId().equalsIgnoreCase(input.getTenantId()) && !this.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(input.getTenantId());
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{input.getTenantId()});
            }
            calcUser.setTenantSid(tenant.getSid());
            calcUser.setTenantId(tenant.getId());
        }
        User user = this.authMapper.findUserByTenantSidAndUserId(calcUser.getTenantSid(), input.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{calcUser.getTenantId(), input.getUserId()});
        }
        calcUser.setUserSid(user.getSid());
        calcUser.setUserId(user.getId());
        calcUser.setUserName(user.getName());
        Sys sys = this.authMapper.findSysByTenantSidAndSysId(calcUser.getTenantSid(), input.getSysId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_SYS_NO_TENANT, new Object[]{input.getSysId(), calcUser.getTenantId()});
        }
        if (0 == this.envProperties.getCloud() && "DigiwinCloud".equalsIgnoreCase(sys.getId())) {
            String cacAuthKey = LoginUser.cacAuthKey(calcUser.getTenantId(), calcUser.getUserId(), "landingconsole");
            AuthAppResultVO result = (AuthAppResultVO)((Object)RedisUtils.get((Object)cacAuthKey, AuthAppResultVO.class));
            if (result != null) {
                calcUser.setAuthLandingConsole(true);
            } else {
                result = this.cacService.getAuthAppResult(calcUser.getTenantId(), calcUser.getUserId(), "landingconsole");
                if (result != null && result.getSuccess()) {
                    calcUser.setAuthLandingConsole(true);
                    RedisUtils.set((String)cacAuthKey, (Object)((Object)result), (Duration)RedisUtil.calcDuration(result.getExpiredDateTime()));
                }
            }
        }
        calcUser.setAppSid(sys.getSid());
        calcUser.setAppId(sys.getId());
        calcUser.setInside(sys.isInside());
        calcUser.setDealer(authoredUser.isDealer());
        calcUser.setEoc(authoredUser.isEoc());
        calcUser.setCorpWechat(authoredUser.isCorpWechat());
        return calcUser;
    }

    @Override
    public void checkDataPermission(DataTargetVO input, AuthoredUser authoredUser, Sys loginSys, Boolean checkUser) {
        Sys sys;
        if ("boss-notifier-management".equals(input.getActionId())) {
            input.setActionId("boss-message-center");
        }
        if (StrUtils.isEmpty((String)input.getTenantId())) {
            input.setTenantId(authoredUser.getTenantId());
        }
        if (StrUtils.isEmpty((String)input.getUserId())) {
            input.setUserId(authoredUser.getUserId());
        }
        if (StrUtils.isEmpty((String)input.getSysId())) {
            input.setSysId(loginSys.getId());
        }
        if (!authoredUser.getTenantId().equalsIgnoreCase(input.getTenantId()) && !"99990000".equals(authoredUser.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(input.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, input.getTenantId());
        }
        input.setTenantSid(tenant.getSid());
        input.setTenantId(tenant.getId());
        if (checkUser.booleanValue()) {
            if (!authoredUser.getUserId().equalsIgnoreCase(input.getUserId()) && !"integration".equalsIgnoreCase(authoredUser.getUserId())) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_ERROR);
            }
            User user = this.authMapper.findUserByTenantSidAndUserId(input.getTenantSid(), input.getUserId());
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{input.getTenantId(), input.getUserId()});
            }
            input.setUserSid(user.getSid());
            input.setUserId(user.getId());
        }
        if ((sys = (Sys)this.sysCrudService.findById(input.getSysId())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{input.getSysId()});
        }
        input.setSysSid(sys.getSid());
        input.setSysId(sys.getId());
        long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{input.getModuleId(), input.getSysSid()});
        if (moduleSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_MODULE_NO_SYS, new Object[]{input.getModuleId(), input.getSysId()});
        }
        input.setModuleSid(moduleSid);
        long tempSid = input.getSelf() ? input.getTenantSid() : 0L;
        long actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{input.getActionId(), moduleSid, tempSid});
        if (actionSid == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_ACTION_NO_MODULE, new Object[]{input.getActionId(), input.getModuleId()});
        }
        input.setActionSid(actionSid);
    }

    @Override
    public Boolean checkAccessPermission(String targetType, String method, String path, String targetId) {
        return this.ramService.targetCanAccessPath(targetType, targetId, method, path);
    }
}

