/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.validate.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.support.validate.LoginCheckService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class LoginCheckServiceImpl
implements LoginCheckService {
    private static final Logger logger = LoggerFactory.getLogger(LoginCheckServiceImpl.class);
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;

    @Override
    public void checkIP(IdentityType identityType, Tenant tenant, Sys sys) {
        if (!IdentityType.general(identityType) || tenant == null || sys == null) {
            return;
        }
        List<String> checkApp = this.whiteListService.getWhiteList("LOGIN_IP_CHECK_APP");
        logger.info("\u9700\u8981\u7ba1\u63a7\u7684\u5e94\u7528:{}\uff0c\u5f53\u524d\u5e94\u7528:{}", (Object)String.join((CharSequence)", ", checkApp), (Object)sys.getId());
        if (checkApp.contains(sys.getId())) {
            String accessIp;
            List tenantIps;
            String tenantIpStr = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "basic", "whiteip");
            logger.info("\u7ba1\u63a7ip:{},\u5f53\u524dip:{}", (Object)tenantIpStr, (Object)UserUtils.getClientIP());
            if (!ObjectUtils.isEmpty((Object)tenantIpStr) && !(tenantIps = Arrays.stream(tenantIpStr.split(",")).collect(Collectors.toList())).contains(accessIp = UserUtils.getClientIP())) {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_IP_CHECK_ERROR, accessIp);
            }
        }
    }
}

