/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.validate.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgTypeVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.support.validate.OrgValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrgValidateServiceImpl
implements OrgValidateService {
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public void checkOrgType(long tenantSid, OrgTypeVO orgTypeVO) {
        if (orgTypeVO == null) {
            throw new IllegalArgumentException("bossOrgTypeVO is null");
        }
        if (!StringUtil.checkId(orgTypeVO.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        OrgType type = this.orgTypeCrudService.findByUnionKey(tenantSid, orgTypeVO.getOrgCatalogSid(), orgTypeVO.getId());
        if (type != null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_HAS_EXIST, new Object[]{orgTypeVO.getId()});
        }
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgTypeVO.getOrgCatalogSid());
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgTypeVO.getOrgCatalogSid()});
        }
        orgTypeVO.setOrgCatalogId(orgCatalog.getId());
    }

    @Override
    public void checkOrg(long tenantSid, OrgVO orgVO) {
        if (orgVO == null) {
            throw new IllegalArgumentException("bossOrgVO is null");
        }
        if (!StringUtil.checkId(orgVO.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        Org oldOrg = (Org)this.orgCrudService.findByUnionKey(new Object[]{tenantSid, orgVO.getOrgAspectSid(), orgVO.getId(), orgVO.getParentSid()});
        if (oldOrg != null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_HAS_EXIST, new Object[]{orgVO.getId()});
        }
        OrgCatalog orgCatalog = (OrgCatalog)this.orgCatalogCrudService.findBySid(orgVO.getOrgCatalogSid());
        if (orgCatalog == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_NO_CATALOG, new Object[]{orgVO.getOrgCatalogSid()});
        }
        orgVO.setOrgCatalogId(orgCatalog.getId());
        OrgAspect orgAspect = (OrgAspect)this.orgAspectCrudService.findBySid(orgVO.getOrgAspectSid());
        if (orgAspect == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ASPECT_NOT_EXISTED, new Object[]{orgVO.getOrgAspectSid()});
        }
        orgVO.setOrgTypeId(orgAspect.getId());
        OrgType orgType = this.orgTypeCrudService.findByTenantSidAndSid(tenantSid, orgVO.getOrgTypeSid());
        if (orgType == null) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_TYPE_NOT_EXISTED, new Object[]{orgVO.getOrgTypeSid()});
        }
    }

    @Override
    public void checkParameters(OrgVO orgVO, AuthoredUser authoredUser, long tenantSid) {
        Org org;
        if (orgVO.getOrgCatalogId() == null && orgVO.getOrgCatalogSid() == 0L) {
            throw new IllegalArgumentException("orgCatalogId or orgCatalogSid is null");
        }
        if (orgVO.getOrgAspectId() == null && orgVO.getOrgAspectSid() == 0L) {
            throw new IllegalArgumentException("orgAspectId or orgAspectSid is null");
        }
        if (orgVO.getTypeId() == null && orgVO.getTypeSid() == 0L) {
            throw new IllegalArgumentException("orgTypeId or orgTypeSid is null");
        }
        if (orgVO.getOrgCatalogSid() == 0L && orgVO.getOrgCatalogId() != null) {
            long orgCatalogSid = this.getOrgCatalogSid(this.orgCatalogCrudService, orgVO.getOrgCatalogSid(), orgVO.getOrgCatalogId(), tenantSid);
            orgVO.setOrgCatalogSid(orgCatalogSid);
        }
        if (orgVO.getOrgAspectSid() == 0L && orgVO.getOrgAspectId() != null) {
            long orgAspectSid = this.getAspectSid(this.orgAspectCrudService, orgVO.getOrgCatalogSid(), orgVO.getOrgAspectId(), tenantSid);
            orgVO.setOrgAspectSid(orgAspectSid);
        }
        if (orgVO.getTypeSid() == 0L && orgVO.getTypeId() != null) {
            long orgTypeSid = this.getOrgTypeSid(this.orgTypeCrudService, orgVO.getOrgCatalogSid(), orgVO.getTypeId(), authoredUser.getTenantSid());
            orgVO.setTypeSid(orgTypeSid);
        }
        if (orgVO.getSid() > 0L && null != (org = (Org)this.orgCrudService.findBySid(orgVO.getSid())) && tenantSid != org.getTenantSid() && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
    }

    protected long getOrgTypeSid(OrgTypeCrudService orgTypeCrudService, long orgCatalogSid, String orgTypeId, long tenantSid) {
        if (StringUtils.isEmpty((Object)orgTypeId)) {
            throw new OperateException("orgTypeId or orgTypeSid is empty");
        }
        return orgTypeCrudService.getSidByUnionKey(tenantSid, orgCatalogSid, orgTypeId);
    }

    protected long getAspectSid(OrgAspectCrudService orgAspectCrudService, long orgCatalogSid, String orgAspectId, long tenantSid) {
        if (StringUtils.isEmpty((Object)orgAspectId)) {
            throw new OperateException("orgAspectId or orgAspectSid is empty");
        }
        return orgAspectCrudService.getSidByUnionKey(new Object[]{tenantSid, orgCatalogSid, orgAspectId});
    }

    protected long getOrgCatalogSid(OrgCatalogCrudService orgCatalogCrudService, long orgCatalogSid, String orgCatalogId, long tenantSid) {
        if (orgCatalogSid > 0L) {
            OrgCatalog orgCatalog = (OrgCatalog)orgCatalogCrudService.findBySid(orgCatalogSid);
            if (orgCatalog != null) {
                if (tenantSid != orgCatalog.getTenantSid()) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
                }
            } else {
                throw new BusinessException((ErrorHandler)I18nError.ORG_CATALOG_NOT_EXISTED, new Object[]{orgCatalogSid});
            }
            return orgCatalogSid;
        }
        if (StringUtils.isEmpty((Object)orgCatalogId) && orgCatalogSid == 0L) {
            throw new OperateException("orgCatalogId or orgCatalogSid is empty");
        }
        orgCatalogSid = orgCatalogCrudService.getSidByTenantAndId(tenantSid, orgCatalogId);
        return orgCatalogSid;
    }
}

