/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.validate.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleVO;
import com.digiwin.dap.middleware.iam.domain.org.DefaultOrgVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.DingTalkImportInfo;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInTagResultVO;
import com.digiwin.dap.middleware.iam.domain.user.RegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.user.UpdateUserBasicInfoVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAuthDO;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.iam.util.vlidator.UserIdValidator;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class OtherValidateServiceImpl
implements OtherValidateService {
    private static final String DIGIWIN_USER_TAG = "digiwin.com";
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public void checkParam(long tenantSid, long userSid) {
        if (tenantSid == 0L) {
            throw new IllegalArgumentException("tenantSid is 0");
        }
        if (userSid == 0L) {
            throw new IllegalArgumentException("userSid is 0");
        }
    }

    @Override
    public void checkInvitedParam(InvitedUserHistory history, long userSid, User user, Tenant tenant) {
        if (null == user) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userSid});
        }
        if (Strings.isEmpty((CharSequence)history.getUserEmail()) && Strings.isEmpty((CharSequence)history.getUserTel()) && 0L == history.getUserSid()) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_OPERATE_USER_INFO);
        }
        if (!StringUtil.equals(history.getUserEmail(), user.getEmail()) && !StringUtil.equals(history.getUserTel(), user.getTelephone()) && history.getUserSid() != userSid) {
            throw new BusinessException((ErrorHandler)I18nError.NO_PERMISSION_OPERATE_USER_INFO);
        }
        if (history.getType().booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NO_AGREE);
        }
        if (!history.getAcceptedStatus().equals(IamConstants.AcceptedStatus.InvitedWaitAgree.name())) {
            throw new BusinessException((ErrorHandler)I18nError.AGREE_OR_REJECT);
        }
        if (null == tenant) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{history.getTenantSid()});
        }
    }

    @Override
    public void verifyUserBasicInfoVO(Long tenantSid, UpdateUserBasicInfoVO userBasicInfoVO) {
        if (userBasicInfoVO.getUser() == null) {
            throw new IllegalArgumentException("user\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Strings.isEmpty((CharSequence)userBasicInfoVO.getUser().getId())) {
            throw new IllegalArgumentException("user.Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Strings.isEmpty((CharSequence)userBasicInfoVO.getUser().getName())) {
            throw new IllegalArgumentException("user.Name\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (userBasicInfoVO.getMetadata() == null) {
            throw new IllegalArgumentException("\u7528\u6237\u9644\u52a0\u4fe1\u606fmetadata\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UserMetadataVO openWeComMetadata = null;
        for (UserMetadataVO userMetadataVO : userBasicInfoVO.getMetadata()) {
            if (Strings.isEmpty((CharSequence)userMetadataVO.getCatalogId()) || !StringUtil.checkId(userMetadataVO.getCatalogId())) {
                throw new IllegalArgumentException("metadat.CatalogId\u4e0d\u89c4\u8303\uff01");
            }
            if (Strings.isEmpty((CharSequence)userMetadataVO.getKey())) {
                throw new IllegalArgumentException("metadat.Key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!"contact".equals(userMetadataVO.getCatalogId()) || !"wechat".equals(userMetadataVO.getKey())) continue;
            if (StringUtils.hasText((String)userMetadataVO.getValue())) {
                WeComUserVO weComUserVO = this.remoteEMCService.checkWechatExistReturnOpenUserId(null, this.tenantRepository.findIdBySid(tenantSid), userMetadataVO.getValue(), userBasicInfoVO.getUser().getId());
                if (Objects.isNull(weComUserVO)) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_WECHAT_EXIST_ERROR);
                }
                if (!StringUtils.hasText((String)weComUserVO.getOpen_userid())) continue;
                openWeComMetadata = new UserMetadataVO("contact", "open_wecom", weComUserVO.getOpen_userid(), tenantSid, userBasicInfoVO.getUser().getSid());
                continue;
            }
            openWeComMetadata = new UserMetadataVO("contact", "open_wecom", "", tenantSid, userBasicInfoVO.getUser().getSid());
        }
        if (Objects.nonNull(openWeComMetadata)) {
            userBasicInfoVO.getMetadata().add(openWeComMetadata);
        }
        if (userBasicInfoVO.getRole() == null) {
            throw new IllegalArgumentException("\u7528\u6237\u89d2\u8272\u5173\u7cfbrole\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (QueryRoleResultVO roleVO : userBasicInfoVO.getRole()) {
            if (!Strings.isEmpty((CharSequence)roleVO.getId()) && StringUtil.checkId(roleVO.getId())) continue;
            throw new IllegalArgumentException("role.Id\u4e0d\u89c4\u8303\uff01");
        }
        if (userBasicInfoVO.getUserInOrg() == null) {
            throw new IllegalArgumentException("\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbuserInOrg\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (QueryUserInOrgResultVO queryUserInOrgResultVO : userBasicInfoVO.getUserInOrg()) {
            if (!Strings.isEmpty((CharSequence)queryUserInOrgResultVO.getOrgUri())) continue;
            throw new IllegalArgumentException("queryUserInOrgResultVO.OrgUri\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (userBasicInfoVO.getDefaultOrg() == null) {
            throw new IllegalArgumentException("\u9884\u8bbe\u7ec4\u7ec7defaultOrg\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (DefaultOrgVO defaultOrgVO : userBasicInfoVO.getDefaultOrg()) {
            if (!Strings.isEmpty((CharSequence)defaultOrgVO.getOrgUri())) continue;
            throw new IllegalArgumentException("defaultOrgVO.OrgUri\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (userBasicInfoVO.getUserInTag() == null) {
            throw new IllegalArgumentException("\u7ec4\u7ec7\u6807\u7b7euserInTag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (QueryUserInTagResultVO queryUserInTagResultVO : userBasicInfoVO.getUserInTag()) {
            if (queryUserInTagResultVO.getTagSid() != 0L) continue;
            throw new IllegalArgumentException("userInTag.tagSid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.verifyUserDataRepeat(tenantSid, userBasicInfoVO);
        this.verifyTelephoneFormat(userBasicInfoVO);
    }

    private void verifyTelephoneFormat(UpdateUserBasicInfoVO userBasicInfoVO) {
        String cellphonePrefix = userBasicInfoVO.getUser().getCellphonePrefix();
        String telephone = userBasicInfoVO.getUser().getTelephone();
        String userId = userBasicInfoVO.getUser().getId();
        if (StringUtils.hasLength((String)userId) && userId.endsWith(DIGIWIN_USER_TAG)) {
            return;
        }
        if (!StringUtils.hasLength((String)telephone)) {
            return;
        }
        String pattern = null;
        if ("+86".equals(cellphonePrefix)) {
            pattern = "^\\d{11}$";
        } else if ("+60".equals(cellphonePrefix) || "+62".equals(cellphonePrefix) || "+66".equals(cellphonePrefix) || "+84".equals(cellphonePrefix) || "+91".equals(cellphonePrefix)) {
            pattern = "^\\d{7,11}$";
        } else if ("+886".equals(cellphonePrefix)) {
            pattern = "^\\d{9,10}$";
        }
        if (StringUtils.hasLength((String)pattern) && !telephone.matches(pattern)) {
            throw new IllegalArgumentException("\u7535\u8bdd\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public void verifyUserDataRepeat(Long tenantSid, UpdateUserBasicInfoVO userBasicInfoVO) {
        UserCondition userCondition;
        User userExist;
        UserInfo userInfo = userBasicInfoVO.getUser();
        User user = userInfo.getSid() != 0L ? (User)this.userCrudService.findBySid(userInfo.getSid()) : (User)this.userCrudService.findById(userInfo.getId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userInfo.getId()});
        }
        if (!(Strings.isEmpty((CharSequence)userInfo.getEmail()) || !Strings.isEmpty((CharSequence)user.getEmail()) && userInfo.getEmail().equals(user.getEmail()) || 1 != user.getType() || null == (userExist = this.userCrudService.queryUserByTenantSidAndCondition(tenantSid, userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).email(userInfo.getEmail()).build())))) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EXIST_ERROR);
        }
        if (!(Strings.isEmpty((CharSequence)userInfo.getTelephone()) || !Strings.isEmpty((CharSequence)user.getTelephone()) && userInfo.getTelephone().equals(user.getTelephone()) || 1 != user.getType() || null == (userExist = this.userCrudService.queryUserByTenantSidAndCondition(tenantSid, userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).telephone(userInfo.getTelephone()).build())))) {
            throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EXIST_ERROR);
        }
    }

    @Override
    public void verifyUserProperties(UserInfo body, User user, boolean isCreate) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((Object)body.getId())) {
            stringBuilder.append("user.Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)body.getName())) {
            stringBuilder.append("user.Name\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (isCreate) {
            User wechatUser;
            if (StringUtils.isEmpty((Object)body.getPassword()) && StringUtils.isEmpty((Object)body.getPasswordHash())) {
                stringBuilder.append("user.Password\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.envProperties.getCheckUserId().booleanValue() && UserIdValidator.validateUserId(body.getId())) {
                stringBuilder.append(String.format("user.Id[%s]\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", body.getId()));
            }
            if (StringUtil.checkUserIdEqualsKeywords(body.getId())) {
                stringBuilder.append(String.format("user.Id\u4e3a\u5173\u952e\u5b57\uff1a[%s]\uff01", body.getId()));
            }
            if (!Strings.isEmpty((CharSequence)body.getEmail())) {
                if (!StringUtil.checkEmail(body.getEmail())) {
                    stringBuilder.append("user.Email\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (!Objects.equals(UserTypeEnum.INTERNAL.getCode(), body.getType()) && this.userRepository.existsByEmailAndType(body.getEmail(), UserTypeEnum.NORMAL.getCode())) {
                    stringBuilder.append("\u8be5\u90ae\u7bb1\u5df2\u7ecf\u6ce8\u518c\uff01");
                }
            }
            if (!Strings.isEmpty((CharSequence)body.getWechat()) && (wechatUser = this.userRepository.findByWechat(body.getWechat())) != null) {
                stringBuilder.append(String.format("\u8be5\u5fae\u4fe1\u53f7\u5df2\u7ecf\u88ab\u7528\u6237[%s]\u6ce8\u518c\uff01", wechatUser.getId()));
            }
            if (!Strings.isEmpty((CharSequence)body.getTelephone()) && !Objects.equals(UserTypeEnum.INTERNAL.getCode(), user.getType()) && this.userRepository.existsByTelephoneAndType(body.getTelephone(), UserTypeEnum.NORMAL.getCode())) {
                stringBuilder.append("\u8be5\u624b\u673a\u5df2\u7ecf\u6ce8\u518c\uff01");
            }
        } else {
            String deTel;
            User wechatUser;
            if (!(Strings.isEmpty((CharSequence)body.getEmail()) || !Strings.isEmpty((CharSequence)user.getEmail()) && body.getEmail().equalsIgnoreCase(user.getEmail()))) {
                if (!StringUtil.checkEmail(body.getEmail())) {
                    stringBuilder.append("user.Email\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (!Objects.equals(UserTypeEnum.INTERNAL.getCode(), user.getType()) && this.userRepository.existsByEmailAndType(body.getEmail(), UserTypeEnum.NORMAL.getCode())) {
                    stringBuilder.append("\u8be5\u90ae\u7bb1\u5df2\u7ecf\u6ce8\u518c\uff01");
                }
            }
            if (!Strings.isEmpty((CharSequence)body.getWechat()) && !body.getWechat().equalsIgnoreCase(user.getWechat()) && (wechatUser = this.userRepository.findByWechat(body.getWechat())) != null) {
                stringBuilder.append(String.format("\u8be5\u5fae\u4fe1\u53f7\u5df2\u7ecf\u88ab\u7528\u6237[%s]\u6ce8\u518c\uff01", wechatUser.getId()));
            }
            if (!(Strings.isEmpty((CharSequence)body.getTelephone()) || !Strings.isEmpty((CharSequence)(deTel = user.getTelephone())) && body.getTelephone().equals(deTel))) {
                if (!StringUtil.isInt(body.getTelephone())) {
                    stringBuilder.append("user.Telephone\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (!Objects.equals(UserTypeEnum.INTERNAL.getCode(), user.getType()) && this.userRepository.existsByTelephoneAndType(body.getTelephone(), UserTypeEnum.NORMAL.getCode())) {
                    stringBuilder.append("\u8be5\u624b\u673a\u5df2\u7ecf\u6ce8\u518c\uff01");
                }
            }
        }
        if (StringUtils.hasLength((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    @Override
    public void verifyRegisterBody(RegisterUserVO body, boolean checkVerificationCode, boolean checkTelephone, boolean checkEmail) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((Object)body.getId())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_1.getMessage());
        }
        if (StringUtils.isEmpty((Object)body.getName())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_2.getMessage());
        }
        if (StringUtils.isEmpty((Object)body.getPassword())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_3.getMessage());
        }
        if (checkEmail && StringUtils.isEmpty((Object)body.getEmail())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_4.getMessage());
        }
        if (checkTelephone && StringUtils.isEmpty((Object)body.getTelephone())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_5.getMessage());
        }
        if (checkVerificationCode && StringUtils.isEmpty((Object)body.getVerificationCode())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_6.getMessage());
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        if (this.envProperties.getCheckUserId().booleanValue() && UserIdValidator.validateUserId(body.getId())) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_7.getMessage(), body.getId()));
        }
        if (StringUtil.checkUserIdEqualsKeywords(body.getId())) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_8.getMessage(), body.getId()));
        }
        if (this.userCrudService.existsById(body.getId())) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_9.getMessage(), body.getId()));
        }
        if (PasswordValidator.validatePassword(body.getPassword())) {
            stringBuilder.append(I18nCode.USER_REGISTER_ERROR_10.getMessage());
        }
        if (checkEmail && !StringUtil.checkEmail(body.getEmail())) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_11.getMessage(), body.getEmail()));
        }
        if (checkEmail && this.userRepository.existsByEmailAndType(body.getEmail(), 0)) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_12.getMessage(), body.getEmail()));
        }
        if (checkTelephone && !StringUtil.isInt(body.getTelephone())) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_13.getMessage(), body.getTelephone()));
        }
        if (checkTelephone && this.userRepository.existsByTelephoneAndType(body.getTelephone(), 0)) {
            stringBuilder.append(String.format(I18nCode.USER_REGISTER_ERROR_14.getMessage(), body.getTelephone()));
        }
        if (!Strings.isBlank((String)stringBuilder.toString())) {
            throw new BusinessException((ErrorHandler)I18nError.CAC_ADD_AUTHORIZATION_ERROR, new Object[]{stringBuilder.toString()});
        }
    }

    @Override
    public void checkOAuthImportUserInfo(DingTalkImportInfo userImportInfo, Boolean batchAuths) {
        if (0 == userImportInfo.getAction()) {
            Assert.hasText((String)userImportInfo.getTenantId(), (String)"tenantId:\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            if (!batchAuths.booleanValue()) {
                Assert.notNull((Object)userImportInfo.getAuth(), (String)"auth:\u6388\u6743\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                this.checkApp(userImportInfo.getAuth().getAppId());
            } else {
                Assert.notEmpty(userImportInfo.getAuths(), (String)"\u6388\u6743\u5e94\u7528\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                userImportInfo.getAuths().forEach(a -> {
                    Assert.notNull((Object)a, (String)"auth:\u6388\u6743\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    this.checkApp(a.getAppId());
                });
            }
            userImportInfo.getUsers().forEach(u -> {
                Assert.hasText((String)u.getId(), (String)"userId:\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)u.getName(), (String)"userName:\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)u.getPassword(), (String)"password:\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                if (!userImportInfo.getEnterprise().booleanValue() && StringUtils.isEmpty((Object)u.getTelephone()) && StringUtils.isEmpty((Object)u.getEmail())) {
                    throw new IllegalStateException("\u7528\u6237\u624b\u673a\u53f7\u6216\u90ae\u7bb1\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                }
            });
        } else {
            Assert.notNull((Object)userImportInfo.getAuth(), (String)"auth:\u6388\u6743\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)userImportInfo.getAuth().getAppId(), (String)"appId:\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
            userImportInfo.getUsers().forEach(u -> {
                Assert.hasText((String)u.getUnionId(), (String)"unionId:\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!StringUtils.isEmpty((Object)u.getTelephone()) || !StringUtils.isEmpty((Object)u.getId()) || !StringUtils.isEmpty((Object)u.getEmail()) ? 1 : 0) != 0, (String)"userId:\u7528\u6237id\u8ddf\u624b\u673a\u53f7\u6216\u90ae\u7bb1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            });
        }
    }

    @Override
    public void addDevModuleCheck(DevModuleVO devModuleVO) {
        if (devModuleVO == null) {
            throw new IllegalArgumentException("devModuleVO is null");
        }
        if (!StringUtil.checkId(devModuleVO.getId())) {
            throw new IllegalArgumentException("id\u4e3a\u7a7a\u6216\u586b\u5199\u9519\u8bef");
        }
        if (StringUtils.isEmpty((Object)devModuleVO.getNameTW())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        if (StringUtils.isEmpty((Object)devModuleVO.getNameCN())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
    }

    @Override
    public void addDevActionCheck(DevActionVO devActionVO) {
        if (devActionVO == null) {
            throw new IllegalArgumentException("devActionRequestVO is null");
        }
        if (!StringUtil.checkSpecialId(devActionVO.getId())) {
            throw new IllegalArgumentException("actionId\u7a7a\u6216\u8005\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff1a\u53f7\uff01");
        }
    }

    @Override
    public void checkParam(GoodsAuthDO goodsAuthDO) {
        if (ObjectUtils.isEmpty((Object)goodsAuthDO.getAppId())) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_MISS);
        }
        if (CollectionUtils.isEmpty(goodsAuthDO.getUserIds()) ? !CollectionUtils.isEmpty(goodsAuthDO.getUserSids()) && goodsAuthDO.getUserSids().size() > 100 : goodsAuthDO.getUserIds().size() > 100) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
    }

    @Override
    public void checkInsideEmail(String email) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)email) && 0 == this.envProperties.getCloud() && email.toLowerCase().contains("@digiwin.com")) {
            throw new BusinessException((ErrorHandler)I18nError.INTERNAL_ACCOUNT, new Object[]{email});
        }
    }

    private void checkApp(String appId) {
        Assert.hasText((String)appId, (String)"appId:\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        Sys sys = (Sys)this.sysRepository.findById(appId);
        if (null == sys) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{appId});
        }
    }
}

