/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.validate.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleVO;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysValidateServiceImpl
implements SysValidateService {
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;

    @Override
    public void check(ModuleVO moduleVO) {
        if (moduleVO == null) {
            throw new IllegalArgumentException("moduleRequestVO is null");
        }
        if (!StringUtil.checkId(moduleVO.getId())) {
            throw new IllegalArgumentException("id\u4e3a\u7a7a\u6216\u586b\u5199\u9519\u8bef");
        }
    }

    @Override
    public void check2(long sysSid, long moduleSid) {
        if (sysSid == 0L) {
            throw new IllegalArgumentException("appSid is 0");
        }
        if (moduleSid == 0L) {
            throw new IllegalArgumentException("moduleSid is 0");
        }
        Sys sys = (Sys)this.sysCrudService.findBySid(sysSid);
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sysSid});
        }
        Module module = (Module)this.moduleCrudService.findBySid(moduleSid);
        if (module == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{moduleSid});
        }
        if (module.getAppSid() != sys.getSid()) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST_APP, new Object[]{moduleSid, sysSid});
        }
    }

    @Override
    public void check3(long sysSid) {
        if (sysSid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
    }

    @Override
    public void check4(long sysSid, long moduleSid) {
        if (sysSid == 0L) {
            throw new IllegalArgumentException("sysSid is 0");
        }
        if (moduleSid == 0L) {
            throw new IllegalArgumentException("moduleSid is 0");
        }
    }

    @Override
    public void check5(long sysSid, long moduleSid, long actionSid) {
        if (sysSid == 0L) {
            throw new IllegalArgumentException("appSid is 0");
        }
        if (moduleSid == 0L) {
            throw new IllegalArgumentException("moduleSid is 0");
        }
        if (actionSid == 0L) {
            throw new IllegalArgumentException("actionSid is 0");
        }
    }

    @Override
    public void check6(ConditionVO conditionVO) {
        if (conditionVO == null) {
            throw new IllegalArgumentException("conditionRequestVO is null");
        }
        if (!StringUtil.checkSpecialId(conditionVO.getKey())) {
            throw new IllegalArgumentException("conditionId\u7a7a\u6216\u8005\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff1a\u53f7\uff01");
        }
    }

    @Override
    public void check7(ActionVO actionVO) {
        if (actionVO == null) {
            throw new IllegalArgumentException("actionRequestVO is null");
        }
        if (!StringUtil.checkSpecialId(actionVO.getId())) {
            throw new IllegalArgumentException("actionId\u7a7a\u6216\u8005\u542b\u6709\u7279\u6b8a\u5b57\u7b26\uff1a\u53f7\uff01");
        }
    }

    @Override
    public void check8(SysVO sysVO) {
        if (sysVO == null) {
            throw new IllegalArgumentException("sysVo is null");
        }
        long oldSysSid = this.sysCrudService.getSidById(sysVO.getId());
        if (oldSysSid != 0L) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_HAS_EXIST, new Object[]{sysVO.getId()});
        }
    }

    @Override
    public long check9(ActionVO actionVO) {
        Sys sys;
        if (actionVO.getSid() > 0L) {
            return this.check10(actionVO);
        }
        if (actionVO.getAppSid() == 0L && actionVO.getAppId() != null) {
            actionVO.setAppSid(this.sysCrudService.getSidById(actionVO.getAppId()));
        }
        if (actionVO.getModuleSid() == 0L && actionVO.getModuleId() != null) {
            actionVO.setModuleSid(this.moduleCrudService.getSidByUnionKey(new Object[]{actionVO.getModuleId(), actionVO.getAppSid()}));
        }
        if (actionVO.getParentSid() == 0L && actionVO.getParentId() != null) {
            actionVO.setParentSid(this.actionCrudService.getSidByUnionKey(new Object[]{actionVO.getParentId(), actionVO.getModuleSid(), actionVO.getTenantSid()}));
        }
        if (actionVO.getParentSid() == 0L && actionVO.getParentId() != null) {
            actionVO.setParentSid(this.actionCrudService.getSidByUnionKey(new Object[]{actionVO.getParentId(), actionVO.getModuleSid(), 0L}));
        }
        if ((sys = (Sys)this.sysCrudService.findBySid(actionVO.getAppSid())) == null) {
            Object err = actionVO.getAppSid() == 0L ? actionVO.getAppId() : Long.valueOf(actionVO.getAppSid());
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{err});
        }
        actionVO.setAppId(sys.getId());
        Module module = (Module)this.moduleCrudService.findBySid(actionVO.getModuleSid());
        if (module == null) {
            Object err = actionVO.getModuleSid() == 0L ? actionVO.getModuleId() : Long.valueOf(actionVO.getModuleSid());
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{err});
        }
        actionVO.setModuleId(module.getId());
        if (module.getAppSid() != sys.getSid()) {
            throw new BusinessException((ErrorHandler)I18nError.PERMISSION_MODULE_NO_SYS, new Object[]{module.getId(), sys.getId()});
        }
        if (actionVO.getParentSid() > 0L || actionVO.getParentId() != null) {
            Action parentAction = (Action)this.actionCrudService.findBySid(actionVO.getParentSid());
            if (parentAction == null) {
                Object err = actionVO.getParentSid() == 0L ? actionVO.getParentId() : Long.valueOf(actionVO.getParentSid());
                throw new BusinessException((ErrorHandler)I18nError.PARENT_ACTION_NOT_EXIST, new Object[]{err});
            }
            actionVO.setParentId(parentAction.getId());
        }
        if (actionVO.getSid() == 0L && actionVO.getId() != null) {
            actionVO.setSid(this.actionCrudService.getSidByUnionKey(new Object[]{actionVO.getId(), actionVO.getModuleSid(), actionVO.getTenantSid()}));
        }
        return actionVO.getSid();
    }

    @Override
    public long check10(ActionVO actionVO) {
        Action action = (Action)this.actionCrudService.findBySid(actionVO.getSid());
        if (action == null) {
            actionVO.setSid(0L);
            return 0L;
        }
        action.setId(action.getId());
        action.setTenantSid(action.getTenantSid());
        Module module = (Module)this.moduleCrudService.findBySid(action.getModuleSid());
        if (module == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{action.getModuleSid()});
        }
        actionVO.setModuleSid(module.getSid());
        actionVO.setModuleId(module.getId());
        Sys sys = (Sys)this.sysCrudService.findBySid(module.getAppSid());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{module.getAppSid()});
        }
        actionVO.setAppSid(sys.getSid());
        actionVO.setAppId(sys.getId());
        return actionVO.getSid();
    }
}

