/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.wecom;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthType;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataQueryService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.oauth.ThirdOauthService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.emc.AppConfigVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginInfo;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class Login4WeComServiceImpl
implements ThirdOauthService {
    private static final Logger logger = LoggerFactory.getLogger(Login4WeComServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private MetadataQueryService metadataQueryService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @Override
    public boolean support(OAuthLoginInfo loginInfo) {
        return OauthType.WeCom.getCode().equals(loginInfo.getOauthType());
    }

    @Override
    public IamAuthoredUser getWebAccessToken(OAuthLoginInfo loginInfo) {
        return this.getUser(loginInfo);
    }

    @Override
    public IamAuthoredUser getAppAccessToken(OAuthLoginInfo loginInfo) {
        return this.getUser(loginInfo);
    }

    private IamAuthoredUser getUser(OAuthLoginInfo loginInfo) {
        User user;
        WeComUserVO weComUserInfo;
        Tenant tenant = (Tenant)this.tenantCrudService.findById(loginInfo.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{loginInfo.getTenantId()});
        }
        List<AppConfigVO> appConfigList = this.remoteEMCService.findAppConfig(loginInfo.getTenantId(), "weCom", "");
        if (CollectionUtils.isEmpty(appConfigList)) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{loginInfo.getAppId()});
        }
        String sysId = UserUtils.getSysId();
        String appId = loginInfo.getAppId();
        AppConfigVO appConfigVO = appConfigList.stream().filter(e -> StringUtils.hasText((String)e.getSysId()) && Objects.equals(e.getSysId(), sysId)).findFirst().orElse(null);
        if (appConfigVO == null) {
            appConfigVO = appConfigList.stream().filter(e -> e.getAppId().equalsIgnoreCase(appId)).findFirst().orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{loginInfo.getAppId()}));
        }
        if (Objects.isNull(weComUserInfo = this.remoteEMCService.getWeComUserInfo(loginInfo.getTenantId(), loginInfo.getAppId(), loginInfo.getCode(), true))) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORITY_CODE_ERROR, new Object[]{loginInfo.getCode()});
        }
        String weComUserId = weComUserInfo.getUserid();
        String userId = null;
        List<UserMetadataVO> userMetas = StringUtils.hasText((String)appConfigVO.getSuiteId()) ? this.metadataQueryService.queryUserMetadataByValue(tenant.getSid(), weComUserId, "contact", "open_wecom") : this.metadataQueryService.queryUserMetadataByValue(tenant.getSid(), weComUserId, "contact", "wechat");
        if (!CollectionUtils.isEmpty(userMetas)) {
            userId = userMetas.get(0).getUserId();
        }
        if (!StringUtils.hasText(userId) && StringUtils.hasLength((String)loginInfo.getMatchProperty())) {
            user = null;
            if ("email".equalsIgnoreCase(loginInfo.getMatchProperty())) {
                if (StringUtils.hasText((String)weComUserInfo.getEmail())) {
                    user = this.userRepository.findFirstByEmailAndType(weComUserInfo.getEmail(), 0);
                }
                if (user == null && StringUtils.hasText((String)weComUserInfo.getMobile())) {
                    user = this.userRepository.findFirstByTelephoneAndType(weComUserInfo.getMobile(), 0);
                }
            } else {
                if (StringUtils.hasText((String)weComUserInfo.getMobile())) {
                    user = this.userRepository.findFirstByTelephoneAndType(weComUserInfo.getMobile(), 0);
                }
                if (user == null && StringUtils.hasText((String)weComUserInfo.getEmail())) {
                    user = this.userRepository.findFirstByEmailAndType(weComUserInfo.getEmail(), 0);
                }
            }
            if (user != null) {
                UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
                if (userInTenant == null || userInTenant.isDisabled() || userInTenant.isDeleted()) {
                    throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_TENANT, new Object[]{user.getId(), tenant.getId()});
                }
                userId = user.getId();
                UserMetadataVO metadata = StringUtils.hasText((String)appConfigVO.getSuiteId()) ? new UserMetadataVO("contact", "open_wecom", weComUserId, tenant.getSid(), user.getSid()) : new UserMetadataVO("contact", "wechat", weComUserId, tenant.getSid(), user.getSid());
                this.metadataUpdateService.updateMetadataValue(metadata);
            }
        }
        if (!StringUtils.hasText(userId)) {
            logger.error("\u3010\u4f01\u5fae\u3011\u6839\u636e\u4f01\u5fae\u6210\u5458\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a, tenantSid:{}, weComUserId:{}", (Object)tenant.getSid(), (Object)weComUserId);
            throw new BusinessException(I18nCode.EXCEL_IMPORT_USER_WECHAT_NOT_IN_TENANT.getMessage());
        }
        user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setDevice(new AuthoredDevice("applet", UserUtils.getAuthoredSys().getId(), "weCom", weComUserId, AppAuthContextHolder.getContext().getClientIP()));
        loginUser.setIdentityType(IdentityType.oauth);
        loginUser.setUser(user);
        loginUser.setTenant(tenant);
        loginUser.setApp(new Sys(UserUtils.getAuthoredSys()));
        return this.authoredUserService.generate(loginUser, true, false);
    }
}

