/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import com.digiwin.dap.middleware.iam.constant.enums.CellphonePrefixEnum;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import java.util.Locale;
import org.springframework.util.StringUtils;

public class CellPhoneUtil {
    public static String getCellPhoneDefault(String area, String telephone) {
        if (!StringUtils.isEmpty((Object)telephone)) {
            if ("CN".equalsIgnoreCase(area)) {
                if (telephone.startsWith("1") && 11 == telephone.length()) {
                    return "+86";
                }
            } else if ("TW".equalsIgnoreCase(area) && telephone.startsWith("0") && 10 == telephone.length()) {
                return "+886";
            }
        }
        return "";
    }

    public static Boolean checkPhoneFormat(String cellPrefix, String telephone, String area) {
        if (StringUtil.equals(cellPrefix, "+86")) {
            return telephone.length() == 11 && StringUtil.checkMobilePhone(telephone);
        }
        if (StringUtil.equals(cellPrefix, "+886")) {
            return StringUtil.checkTWMobilePhone(telephone);
        }
        if (StringUtil.equals(cellPrefix, CellphonePrefixEnum.MALAYSIA.getPrefix()) || StringUtil.equals(cellPrefix, CellphonePrefixEnum.VIETNAM.getPrefix()) || StringUtil.equals(cellPrefix, CellphonePrefixEnum.THAILAND.getPrefix()) || StringUtil.equals(cellPrefix, CellphonePrefixEnum.INDIA.getPrefix()) || StringUtil.equals(cellPrefix, CellphonePrefixEnum.INDONISIA.getPrefix())) {
            return telephone.trim().length() >= 7 && telephone.trim().length() <= 11 && StringUtil.checkOtherMobilePhone(telephone);
        }
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(area)) {
            return StringUtil.checkTWMobilePhone(telephone);
        }
        return StringUtil.checkMobilePhone(telephone);
    }
}

