/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdExecution;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdInfo;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdStatus;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dom4jUtil {
    private static final Logger logger = LoggerFactory.getLogger(Dom4jUtil.class);
    private static final Map<String, Client> clientMap = new HashMap<String, Client>(3);

    public static Client getJaxWsDynamicClient(String area, String wsdlUrl) {
        Client client = clientMap.get(area);
        if (client == null) {
            try {
                JaxWsDynamicClientFactory factory = JaxWsDynamicClientFactory.newInstance();
                client = factory.createClient(wsdlUrl);
                HTTPConduit conduit = (HTTPConduit)client.getConduit();
                HTTPClientPolicy policy = new HTTPClientPolicy();
                policy.setConnectionTimeout(15000L);
                policy.setAllowChunking(false);
                policy.setReceiveTimeout(15000L);
                conduit.setClient(policy);
                clientMap.put(area, client);
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316[{}]Client\uff0c\u9519\u8bef\uff1a{}", (Object)wsdlUrl, (Object)e.getMessage());
            }
        }
        return client;
    }

    public static String checkADEncrypted(String username, String password) {
        try {
            long start = System.currentTimeMillis();
            logger.info("check AD with encrypted");
            Client client = Dom4jUtil.getJaxWsDynamicClient("encrypt", "https://misws.digiwin.com/adauth/adauth.asmx?WSDL");
            if (client != null) {
                password = Dom4jUtil.encryptPassword(password);
                Object[] objects = client.invoke("Check_ActDirec", new Object[]{Dom4jUtil.getRequestXmlEncrypt(username, password)});
                logger.info("check AD with encrypted success,took:{}ms", (Object)(System.currentTimeMillis() - start));
                return objects[0].toString();
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6AD\u6821\u9a8c\u670d\u52a1\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static String checkLdapAliyun(String username, String password) {
        try {
            long start = System.currentTimeMillis();
            logger.info("check AD with aliyun");
            Client client = Dom4jUtil.getJaxWsDynamicClient("aliyun", "http://139.196.198.113/ADauth/ADauth.asmx?WSDL");
            if (client != null) {
                Object[] objects = client.invoke("Check_Account", new Object[]{Dom4jUtil.getRequestXmlCN(username, password)});
                logger.info("check AD with aliyun success,took:{}ms", (Object)(System.currentTimeMillis() - start));
                return objects[0].toString();
            }
        }
        catch (Exception e) {
            logger.error("Aliyun\u670d\u52a1\u5668AD\u6821\u9a8c\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static String checkLdapCn(String username, String password) {
        try {
            long start = System.currentTimeMillis();
            logger.info("check AD with cn");
            Client client = Dom4jUtil.getJaxWsDynamicClient("cn", "http://mobile2.digiwin.com.cn:8081/ADauth/ADauth.asmx?WSDL");
            if (client != null) {
                Object[] objects = client.invoke("Check_Account", new Object[]{Dom4jUtil.getRequestXmlCN(username, password)});
                logger.info("check AD with cn success,took:{}ms", (Object)(System.currentTimeMillis() - start));
                return objects[0].toString();
            }
        }
        catch (Exception e) {
            logger.error("\u5927\u9646\u670d\u52a1\u5668AD\u6821\u9a8c\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static String checkLdapTw(String username, String password) {
        try {
            long start = System.currentTimeMillis();
            logger.info("check AD with tw");
            Client client = Dom4jUtil.getJaxWsDynamicClient("tw", "http://misws.digiwin.com/ADauth/ADauth.asmx?WSDL");
            if (client != null) {
                Object[] objects = client.invoke("Check_Account", new Object[]{Dom4jUtil.getRequestXmlTW(username, password)});
                logger.info("check AD with tw success,took:{}ms", (Object)(System.currentTimeMillis() - start));
                return objects[0].toString();
            }
        }
        catch (Exception e) {
            logger.error("\u53f0\u6e7e\u670d\u52a1\u5668AD\u6821\u9a8c\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static AdExecution getAdExecution(String xmlStr) {
        Document doc;
        try {
            doc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (Exception e) {
            logger.error("AD\u9a8c\u8bc1\u7ed3\u679c\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.AD_RESULT_PARSE_FAILED);
        }
        Element root = doc.getRootElement();
        Element execution = root.element("Execution");
        Element status = execution.element("Status");
        Element info = execution.element("Info");
        AdExecution adExecution = new AdExecution();
        AdStatus adStatus = new AdStatus();
        adStatus.setCode(status.attribute("Code").getValue());
        adStatus.setMessage(status.attribute("Message").getValue());
        adExecution.setStatus(adStatus);
        if ("0".equals(adStatus.getCode())) {
            AdInfo adInfo = new AdInfo();
            if (null == info) {
                throw new BusinessException((ErrorHandler)I18nError.AD_RESULT_PARSE_USER_IS_NULL, new Object[]{xmlStr});
            }
            Attribute name = info.attribute("Name");
            if (name == null) {
                throw new BusinessException((ErrorHandler)I18nError.AD_RESULT_PARSE_USER_NAME_IS_NULL);
            }
            adInfo.setName(name.getValue());
            adInfo.setMail(info.attribute("Mail").getValue());
            adInfo.setjCode(info.attribute("JCode").getValue());
            adInfo.setExt(info.attribute("Ext").getValue());
            adInfo.setDept(info.attribute("Dept").getValue());
            adInfo.setArea(info.attribute("Area").getValue());
            adInfo.setFloor(info.attribute("Floor").getValue());
            adInfo.setEmpType(info.attribute("EmpType").getValue());
            adInfo.setJobTitle(info.attribute("JobTitle").getValue());
            adInfo.setDeptName(info.attribute("DeptName").getValue());
            adInfo.setDeptName2(info.attribute("DeptName2").getValue());
            adInfo.setAreaCode(info.attribute("AreaCode").getValue());
            adExecution.setInfo(adInfo);
        } else {
            System.out.println("AD\u9a8c\u8bc1\u7ed3\u679c\u5931\u8d25" + doc.asXML());
        }
        return adExecution;
    }

    private static String getRequestXmlTW(String username, String password) {
        return String.format("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:digi=\"http://digiwin.biz/\">  \n  <soap:Header/>\n  <soap:Body>\n    <digi:Check_Account>\n      <digi:RequestXML> \n        <Request> \n          <Access> \n            <App value=\"DMobileCAC\"/>  \n            <GetInfo value=\"true\"/>  \n            <AuthUser value=\"%s\"/>  \n            <AuthPSW value=\"%s\"/> \n          </Access> \n        </Request> \n      </digi:RequestXML>\n    </digi:Check_Account>\n  </soap:Body>\n</soap:Envelope>", username, password);
    }

    private static String getRequestXmlEncrypt(String username, String password) {
        return String.format("<Request> \n<Access>  \n<App value=\"PassMiddleware\"/> \n<AuthUser value=\"%s\"/> \n<AuthPSW value=\"%s\"/> \n<GetInfo value=\"true\"/>  \n</Access>  \n</Request>", username, password);
    }

    private static String encryptPassword(String password) {
        try {
            byte[] modulusBytes = Base64.getDecoder().decode("46EepihKdYvQWMlgQsD8jBYgZOTAadv9F1C8uAEtRhFzYmli2E3O5o9bW/J5dGrxvvZ+MmnOCttTn0Or5wngXoNSwdaWsp2lFnaZByy7IbLLy5BFZTKAyvKZZl+dy75IpyzrMGEPjjUFUwrW5dQoeJDApfHzhhRKQ0RwTIWUHV0=");
            byte[] exponentBytes = Base64.getDecoder().decode("AQAB");
            BigInteger modulus = new BigInteger(1, modulusBytes);
            BigInteger exponent = new BigInteger(1, exponentBytes);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = factory.generatePublic(spec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] encryptedBytes = cipher.doFinal(password.getBytes());
            return Base64.getEncoder().encodeToString(encryptedBytes);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    private static String getRequestXmlCN(String username, String password) {
        return String.format("<Request> \n<Access>  \n<App value=\"DsInfo\"/> \n<AuthUser value=\"%s\"/> \n<AuthPSW value=\"%s\"/> \n<GetInfo value=\"true\"/>  \n</Access>  \n</Request>", username, password);
    }

    public static void main(String[] args) throws Exception {
        AdExecution aliyunMan = Dom4jUtil.getAdExecution(Dom4jUtil.checkLdapAliyun("sharonchen", "***"));
        AdExecution cnMan = Dom4jUtil.getAdExecution(Dom4jUtil.checkLdapCn("sharonchen", "***"));
        AdExecution twMan = Dom4jUtil.getAdExecution(Dom4jUtil.checkLdapTw("sharonchen", "***"));
        System.out.println("AliyunMan = " + aliyunMan);
        System.out.println("CNMan = " + cnMan);
        System.out.println("TWMan = " + twMan);
    }
}

