/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelFillCellMergeStrategy
implements CellWriteHandler {
    private int[] mergeColumnIndex;
    private int mergeRowIndex;

    public ExcelFillCellMergeStrategy() {
    }

    public ExcelFillCellMergeStrategy(int mergeRowIndex, int[] mergeColumnIndex) {
        this.mergeRowIndex = mergeRowIndex;
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        int curRowIndex = cell.getRowIndex();
        int curColIndex = cell.getColumnIndex();
        if (curRowIndex > this.mergeRowIndex) {
            for (int i = 0; i < this.mergeColumnIndex.length; ++i) {
                if (curColIndex != this.mergeColumnIndex[i]) continue;
                this.mergeWithPrevRow(writeSheetHolder, cell, curRowIndex, curColIndex);
                break;
            }
        }
    }

    private void mergeWithPrevRow(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex) {
        String preAppData;
        String curAppData = cell.getSheet().getRow(curRowIndex).getCell(0).getStringCellValue();
        if (curAppData.equals(preAppData = cell.getSheet().getRow(curRowIndex - 1).getCell(0).getStringCellValue())) {
            Sheet sheet = writeSheetHolder.getSheet();
            List mergeRegions = sheet.getMergedRegions();
            boolean isMerged = false;
            for (int i = 0; i < mergeRegions.size() && !isMerged; ++i) {
                CellRangeAddress cellRangeAddr = (CellRangeAddress)mergeRegions.get(i);
                if (!cellRangeAddr.isInRange(curRowIndex - 1, curColIndex)) continue;
                sheet.removeMergedRegion(i);
                cellRangeAddr.setLastRow(curRowIndex);
                sheet.addMergedRegion(cellRangeAddr);
                isMerged = true;
            }
            if (!isMerged) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex - 1, curRowIndex, curColIndex, curColIndex);
                sheet.addMergedRegion(cellRangeAddress);
            }
        }
    }

    public static HorizontalCellStyleStrategy getStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setWrapped(Boolean.valueOf(true));
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        contentWriteFont.setFontName("\u5fae\u8edf\u6b63\u9ed1\u9ad4");
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public static HorizontalCellStyleStrategy getTenantApplicationStyleStrategy() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setWrapped(Boolean.valueOf(true));
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        contentWriteFont.setFontName("\u5fae\u8edf\u6b63\u9ed1\u9ad4");
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setTopBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        contentWriteCellStyle.setBottomBorderColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }

    public int[] getMergeColumnIndex() {
        return this.mergeColumnIndex;
    }

    public int getMergeRowIndex() {
        return this.mergeRowIndex;
    }

    public void setMergeColumnIndex(int[] mergeColumnIndex) {
        this.mergeColumnIndex = mergeColumnIndex;
    }

    public void setMergeRowIndex(int mergeRowIndex) {
        this.mergeRowIndex = mergeRowIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelFillCellMergeStrategy)) {
            return false;
        }
        ExcelFillCellMergeStrategy other = (ExcelFillCellMergeStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMergeRowIndex() != other.getMergeRowIndex()) {
            return false;
        }
        return Arrays.equals(this.getMergeColumnIndex(), other.getMergeColumnIndex());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelFillCellMergeStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMergeRowIndex();
        result = result * 59 + Arrays.hashCode(this.getMergeColumnIndex());
        return result;
    }

    public String toString() {
        return "ExcelFillCellMergeStrategy(mergeColumnIndex=" + Arrays.toString(this.getMergeColumnIndex()) + ", mergeRowIndex=" + this.getMergeRowIndex() + ")";
    }
}

