/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.opensaml.security.x509.BasicX509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDPCredentialsUtil {
    private static final Logger logger = LoggerFactory.getLogger(IDPCredentialsUtil.class);

    public static X509Certificate getX509CertificateFromString(String credentials) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        byte[] certificateData = Base64.getDecoder().decode(IDPCredentialsUtil.removeCertificateBeginEndLines(credentials));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateData);
        return (X509Certificate)certificateFactory.generateCertificate(inputStream);
    }

    public static String removeCertificateBeginEndLines(String credentials) {
        String replacedStr = credentials.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replaceAll("\n", "").replaceAll(" ", "");
        logger.info("replaced credentials:{}", (Object)replacedStr);
        return replacedStr;
    }

    public static BasicX509Credential getBasicX509CredentialFromString(String credentials) throws CertificateException {
        return new BasicX509Credential(IDPCredentialsUtil.getX509CertificateFromString(credentials));
    }
}

