/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import java.time.Duration;
import java.time.LocalDateTime;

public class RedisUtil {
    private static final String KEY_PREFIX = "iam";
    private static final String COLON = ":";

    public static String keyBuilder(String module, String func, String ... args) {
        StringBuffer key = new StringBuffer(KEY_PREFIX);
        key.append(COLON).append(module).append(COLON).append(func);
        for (String arg : args) {
            key.append(COLON).append(arg);
        }
        return key.toString();
    }

    public static Duration calcDuration(LocalDateTime expiredDateTime) {
        LocalDateTime now = LocalDateTime.now();
        if (now.plusDays(7L).isBefore(expiredDateTime)) {
            return Duration.ofDays(7L);
        }
        return Duration.between(now, expiredDateTime);
    }
}

