/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataSAMLVO;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLUtil {
    private static final Logger logger = LoggerFactory.getLogger(SAMLUtil.class);
    private static final RandomIdentifierGenerationStrategy secureRandomIdGenerator = new RandomIdentifierGenerationStrategy();

    public static String generateSecureRandomId() {
        return secureRandomIdGenerator.generateIdentifier();
    }

    public static AuthnRequest buildAuthnRequest(String tenantId, TenantMetadataSAMLVO samlVO, SysSsoUrlConfig samlSys, String iamUri) {
        AuthnRequest authnRequest = SAMLUtil.buildSAMLObject(AuthnRequest.class);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setDestination(samlVO.getSsoUrl());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setAssertionConsumerServiceURL(SAMLUtil.getAssertionConsumerEndpoint(iamUri, tenantId, samlSys));
        authnRequest.setID(SAMLUtil.generateSecureRandomId());
        authnRequest.setIssuer(SAMLUtil.buildIssuer(iamUri));
        authnRequest.setNameIDPolicy(SAMLUtil.buildNameIdPolicy());
        authnRequest.setRequestedAuthnContext(SAMLUtil.buildRequestedAuthnContext());
        return authnRequest;
    }

    public static LogoutRequest buildLogoutRequest(TenantMetadataSAMLVO samlVO, String iamUri, String nameId, String sessionIndexVal) {
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        logoutRequest.setID(SAMLUtil.generateSecureRandomId());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        logoutRequest.setIssueInstant(new DateTime());
        logoutRequest.setDestination(samlVO.getLogoutUrl());
        NameID nameID = new NameIDBuilder().buildObject();
        nameID.setValue(nameId);
        logoutRequest.setNameID(nameID);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(sessionIndexVal);
        logoutRequest.getSessionIndexes().add(sessionIndex);
        logoutRequest.setIssuer(SAMLUtil.buildIssuer(iamUri));
        return logoutRequest;
    }

    public static RequestedAuthnContext buildRequestedAuthnContext() {
        RequestedAuthnContext requestedAuthnContext = SAMLUtil.buildSAMLObject(RequestedAuthnContext.class);
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
        AuthnContextClassRef passwordAuthnContextClassRef = SAMLUtil.buildSAMLObject(AuthnContextClassRef.class);
        passwordAuthnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        requestedAuthnContext.getAuthnContextClassRefs().add(passwordAuthnContextClassRef);
        return requestedAuthnContext;
    }

    public static NameIDPolicy buildNameIdPolicy() {
        NameIDPolicy nameIDPolicy = SAMLUtil.buildSAMLObject(NameIDPolicy.class);
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        return nameIDPolicy;
    }

    public static Issuer buildIssuer(String iamUri) {
        Issuer issuer = SAMLUtil.buildSAMLObject(Issuer.class);
        issuer.setValue(iamUri);
        return issuer;
    }

    public static Endpoint getIDPEndpoint(TenantMetadataSAMLVO samlVO, boolean login) {
        SingleSignOnService endpoint = SAMLUtil.buildSAMLObject(SingleSignOnService.class);
        if ("REDIRECT".equals(samlVO.getBindType())) {
            endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        } else {
            endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        }
        if (login) {
            endpoint.setLocation(samlVO.getSsoUrl());
        } else {
            endpoint.setLocation(samlVO.getLogoutUrl());
        }
        return endpoint;
    }

    public static String getAssertionConsumerEndpoint(String iamUri, String tenantId, SysSsoUrlConfig samlSys) {
        return String.format("%s/api/iam/v2/saml/acs/%s/%s", iamUri, tenantId, samlSys.getSysId());
    }

    public static <T> T buildSAMLObject(Class<T> clazz) {
        XMLObject object = null;
        try {
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            QName defaultElementName = (QName)clazz.getDeclaredField("DEFAULT_ELEMENT_NAME").get(null);
            object = builderFactory.getBuilder(defaultElementName).buildObject(defaultElementName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not create SAML object");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Could not create SAML object");
        }
        return (T)object;
    }

    public static String getFailCallbackUrl(String failCallbackUrl, String errorMsg) {
        String joinFlag = failCallbackUrl.contains("?") ? "&" : "?";
        return failCallbackUrl + joinFlag + "errormsg=" + SAMLUtil.urlEncode(errorMsg);
    }

    public static String getSuccessCallbackUrl(String successCallbackUrl, String code, String nameId, String sessionIndex) {
        String joinFlag = successCallbackUrl.contains("?") ? "&" : "?";
        return successCallbackUrl + joinFlag + "code=" + code + "&nameId=" + nameId + "&sessionIndex=" + sessionIndex;
    }

    private static String urlEncode(String msg) {
        try {
            return URLEncoder.encode(msg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u3010saml\u3011 urlEncode\u5f02\u5e38", (Throwable)e);
            return msg;
        }
    }

    public static void signXMLObject(SignableXMLObject signableXMLObject, Credential signingCredential) throws MarshallingException, SignatureException {
        Signature signature = SAMLUtil.buildSAMLObject(Signature.class);
        signature.setSigningCredential(signingCredential);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signableXMLObject.setSignature(signature);
        XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)signableXMLObject).marshall((XMLObject)signableXMLObject);
        Signer.signObject((Signature)signature);
    }

    public static ParserPool getParserPool() {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.setMaxPoolSize(100);
        parserPool.setCoalescing(true);
        parserPool.setIgnoreComments(true);
        parserPool.setIgnoreElementContentWhitespace(true);
        parserPool.setNamespaceAware(true);
        parserPool.setExpandEntityReferences(false);
        parserPool.setXincludeAware(false);
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        parserPool.setBuilderFeatures(features);
        parserPool.setBuilderAttributes(new HashMap());
        try {
            parserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return parserPool;
    }
}

