/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util;

import com.digiwin.dap.middleware.iam.support.remote.domain.ad.BaseAd;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class StringUtil {
    private static final String COLON = ":";
    private static final int PARAMETER_MIN_LENGTH = 1;
    private static final int PARAMETER_MAX_LENGTH = 100;

    public static boolean isInt(String str) {
        return str.matches("[0-9]+");
    }

    public static boolean checkUserId(String userId) {
        return userId.length() <= 100 && userId.length() > 1 && !StringUtils.isEmpty((Object)userId) && !userId.contains("/") && !userId.contains("\\") && !".".equals(userId.substring(userId.length() - 1));
    }

    public static boolean checkUserIdEqualsKeywords(String userId) {
        return "guest".equalsIgnoreCase(userId) || "administrator".equalsIgnoreCase(userId) || "administrators".equalsIgnoreCase(userId) || "superadmin".equalsIgnoreCase(userId) || "integration".equalsIgnoreCase(userId) || "virtual".equalsIgnoreCase(userId);
    }

    public static boolean checkId(String id) {
        return !StringUtils.isEmpty((Object)id) && id.length() <= 100;
    }

    public static boolean checkTenantId(String id) {
        return !StringUtils.isEmpty((Object)id) && !id.contains("/") && !id.contains("\\") && !id.contains(".");
    }

    public static boolean checkSpecialId(String id) {
        return !StringUtils.isEmpty((Object)id) && !id.contains(COLON);
    }

    public static boolean checkEmail(String email) {
        String emailRegex = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
        return email.matches(emailRegex);
    }

    public static boolean checkMobilePhone(String mobilePhone) {
        String mobilePhoneRegex = "^[1][3,4,5,6,7,8,9][0-9]{9}$";
        return mobilePhone.matches(mobilePhoneRegex);
    }

    public static boolean checkTWMobilePhone(String mobilePhone) {
        String mobilePhoneRegex = "^([0-9]){9,10}$";
        return mobilePhone.matches(mobilePhoneRegex);
    }

    public static boolean checkOtherMobilePhone(String mobilePhone) {
        String mobilePhoneRegex = "^([0-9]){7,11}$";
        return mobilePhone.matches(mobilePhoneRegex);
    }

    public static boolean checkUrl(String url) {
        String urlRegex = "^(https?)://([^/]+)(\\/[^?]+)?(\\?[^#]+)?(#.*)?$";
        return url.matches(urlRegex);
    }

    public static String truncateString(String origin, int count) {
        char[] originArr = origin.toCharArray();
        if (origin.length() > count) {
            char[] ret = new char[count];
            System.arraycopy(originArr, 0, ret, 0, count);
            return String.copyValueOf(ret);
        }
        return origin;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str2 != null && str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str2 != null && str1.equalsIgnoreCase(str2);
    }

    public static boolean checkMetaLanguage(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return false;
        }
        return value.length() < 6;
    }

    public static String getAdCompanyId(String companyId, BaseAd ad) {
        if (StringUtils.hasLength((String)companyId)) {
            return companyId;
        }
        String[] strings = ad.getDistinguishedName().split(",");
        StringBuilder stringBuilder = new StringBuilder();
        boolean start = true;
        for (String s : strings) {
            if (!s.startsWith("DC=")) continue;
            if (!start) {
                stringBuilder.append(".");
            }
            stringBuilder.append(s.split("=")[1]);
            start = false;
        }
        return stringBuilder.toString();
    }

    public static boolean containsNonEnglishDigits(String input) {
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9\\-]");
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static String getUniqueActionName(String moduleId, String actionId) {
        return moduleId + "&&" + actionId;
    }
}

