/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util.excelUtil;

import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelColumnSetting;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelSheetSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DWExcelBuilder {
    private List<DWExcelSheetSetting> sheets = new ArrayList<DWExcelSheetSetting>();

    public DWExcelSheetSetting addSheet(String sheetName) {
        DWExcelSheetSetting sheet = new DWExcelSheetSetting();
        sheet.setSheetName(sheetName);
        this.sheets.add(sheet);
        return sheet;
    }

    public List<DWExcelSheetSetting> getSheets() {
        return this.sheets;
    }

    protected Workbook build() throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (DWExcelSheetSetting sheet : this.getSheets()) {
            this.buildSheet(workbook, sheet);
        }
        return workbook;
    }

    protected void buildSheet(XSSFWorkbook workbook, DWExcelSheetSetting sheetSetting) throws Exception {
        XSSFSheet sheet = workbook.createSheet(sheetSetting.getSheetName());
        this.buildTitleRow(sheet, sheetSetting);
        int rowIndex = 1;
        List<Map<String, Object>> datas = sheetSetting.getDatas();
        for (Map<String, Object> data : datas) {
            this.buildDataRow(sheet, sheetSetting, data, rowIndex++);
        }
    }

    protected void buildTitleRow(XSSFSheet sheet, DWExcelSheetSetting sheetSetting) {
        int columnIndex = 0;
        XSSFRow titleRow = sheet.createRow(0);
        for (DWExcelColumnSetting column : sheetSetting.getColumns()) {
            titleRow.createCell(columnIndex++).setCellValue(column.getTitle());
            sheet.autoSizeColumn(columnIndex);
        }
    }

    protected void buildDataRow(XSSFSheet sheet, DWExcelSheetSetting sheetSetting, Map<String, Object> data, int rowIndex) throws Exception {
        int columnIndex = 0;
        XSSFRow dataRow = sheet.createRow(rowIndex);
        for (DWExcelColumnSetting columnSetting : sheetSetting.getColumns()) {
            XSSFCell cell = dataRow.createCell(columnIndex++);
            columnSetting.getCellProcessor().process((Cell)cell, columnSetting, data);
        }
    }

    public Workbook create() throws Exception {
        Workbook workbook = this.build();
        return workbook;
    }
}

