/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util.excelUtil;

import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelCellDecorator;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelCellProcessor;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelCellValueConverter;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelColumnSetting;
import java.util.ArrayList;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;

public class DWExcelCellBaseProcessor
implements DWExcelCellProcessor {
    private DWExcelCellValueConverter converter;
    private DWExcelCellDecorator decorator;

    @Override
    public void setCellValueConverter(DWExcelCellValueConverter converter) {
        if (this.converter != null && converter != null && this.converter != converter && converter.getFormat() == null) {
            converter.setFormat(this.converter.getFormat());
        }
        this.converter = converter;
    }

    @Override
    public DWExcelCellValueConverter getCellValueConverter() {
        return this.converter;
    }

    @Override
    public void setCellDecorator(DWExcelCellDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public DWExcelCellDecorator getCellDecorator() {
        return this.decorator;
    }

    @Override
    public void process(Cell cell, DWExcelColumnSetting columnSetting, Map<String, Object> rowData) throws Exception {
        Object cellSourceData = this.getCellSourceData(columnSetting, rowData);
        Object cellValue = this.setCellValue(cell, columnSetting, cellSourceData);
        this.setCellStyle(cell, columnSetting, cellSourceData, cellValue);
    }

    protected Object setCellValue(Cell cell, DWExcelColumnSetting columnSetting, Object cellSourceData) throws Exception {
        Object cellValue = this.convertSourceValueToCellValue(columnSetting, cellSourceData, this.converter);
        if (cellValue != null) {
            cell.setCellValue(String.valueOf(cellValue));
        }
        return cellValue;
    }

    protected void setCellStyle(Cell cell, DWExcelColumnSetting columnSetting, Object cellSourceData, Object cellValue) throws Exception {
        DWExcelCellDecorator decorator = this.decorator;
        if (decorator != null) {
            decorator.style(cell, columnSetting, cellSourceData, cellValue);
        }
    }

    protected Object getCellSourceData(DWExcelColumnSetting columnSetting, Map<String, Object> rowData) {
        String[] dataMappingKeys = columnSetting.getDataMappingKeys();
        if (dataMappingKeys == null || dataMappingKeys.length == 0) {
            return null;
        }
        if (dataMappingKeys.length == 1) {
            Object value = rowData.get(dataMappingKeys[0]);
            if (columnSetting.isIntegerType() && value instanceof Number) {
                value = ((Number)value).intValue();
            }
            return value;
        }
        ArrayList<Object> sourceValues = new ArrayList<Object>();
        for (String key : dataMappingKeys) {
            sourceValues.add(rowData.get(key));
        }
        return sourceValues;
    }

    protected Object convertSourceValueToCellValue(DWExcelColumnSetting columnSetting, Object cellSourceData, DWExcelCellValueConverter converter) throws Exception {
        Object cellValue = converter == null ? cellSourceData : converter.convert(columnSetting, cellSourceData);
        return cellValue;
    }
}

