/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.util.excelUtil;

import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelCellValueConverter;
import com.digiwin.dap.middleware.iam.util.excelUtil.DWExcelColumnSetting;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DWExcelCellValueBaseConverter
implements DWExcelCellValueConverter {
    private Object defaultValue = null;
    private Map<Object, Object> conversionMap = new HashMap<Object, Object>();
    private String cellValueFormat = null;

    @Override
    public String getFormat() {
        return this.cellValueFormat;
    }

    @Override
    public void setFormat(String format) {
        this.cellValueFormat = format;
    }

    @Override
    public void addConversion(Object sourceValue, Object conversionValue) {
        this.conversionMap.put(sourceValue, conversionValue);
    }

    @Override
    public void setConversionDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Object convert(DWExcelColumnSetting columnSetting, Object cellSourceData) throws Exception {
        Object conversionValue = this.convertCellValue(columnSetting, cellSourceData);
        conversionValue = this.format(conversionValue);
        return conversionValue;
    }

    protected Object convertCellValue(DWExcelColumnSetting columnSetting, Object cellSourceData) {
        Object conversionValue = this.conversionMap.size() > 0 ? (cellSourceData != null && this.conversionMap.containsKey(cellSourceData) ? this.conversionMap.get(cellSourceData) : (this.defaultValue == null ? cellSourceData : this.defaultValue)) : cellSourceData;
        return conversionValue;
    }

    @Override
    public Object format(Object sourceValue) {
        boolean isMultipleSourceValue = sourceValue instanceof Collection;
        String format = this.getFormat();
        if (isMultipleSourceValue) {
            Collection sourceValues = (Collection)sourceValue;
            if (format == null) {
                format = StringUtils.leftPad((String)"%s", (int)sourceValues.size());
            }
            Object[] valueArray = sourceValues.stream().map(o -> o == null ? "" : o).toArray();
            return String.format(format, valueArray);
        }
        if (format == null) {
            return sourceValue;
        }
        return String.format(format, sourceValue);
    }
}

