package com.digiwin.dap.middleware.lmc.common.parser;


import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;

/**
 * Used to convert an result stream to a java object.
 *
 * @author chenzhuang
 * @date 2021/4/23
 */
public interface ResponseParser<T> {

    /**
     * Converts the result from stream to a java object.
     *
     * @param response The http response message.
     * @return The java Type T object that the result stands for.
     * @throws ResponseParseException Failed to parse the result.
     */
    T parse(ResponseMessage response) throws ResponseParseException;
}
