package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.comm.HttpDeleteWithBody;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.HttpMethod;
import com.digiwin.dap.middleware.lmc.http.utils.HttpHeaders;
import com.digiwin.dap.middleware.lmc.internal.LmcConstant;
import org.apache.hc.client5.http.classic.methods.*;

import java.net.URI;
import java.util.Map.Entry;

class HttpRequestFactory {

    public HttpUriRequestBase createHttpRequest(RequestMessage request) {
        URI uri = request.getEndpoint();

        HttpUriRequestBase httpRequest;
        HttpMethod method = request.getMethod();

        switch (method) {
            case POST:
                HttpPost post = new HttpPost(uri);
                if (request.getHttpEntity() != null) {
                    post.setEntity(request.getHttpEntity());
                }
                httpRequest = post;
                break;

            case PUT:
                HttpPut put = new HttpPut(uri);
                if (request.getHttpEntity() != null) {
                    put.setEntity(request.getHttpEntity());
                }
                httpRequest = put;
                break;

            case GET:
                httpRequest = new HttpGet(uri);
                break;

            case DELETE:
                if (request.getHttpEntity() != null) {
                    HttpDeleteWithBody delete = new HttpDeleteWithBody(uri);
                    delete.setEntity(request.getHttpEntity());
                    httpRequest = delete;
                } else {
                    httpRequest = new HttpDelete(uri);
                }
                break;

            case HEAD:
                httpRequest = new HttpHead(uri);
                break;

            case OPTIONS:
                httpRequest = new HttpOptions(uri);
                break;

            default:
                throw new ClientException("Unknown HTTP method name: " + method);
        }

        configureRequestHeaders(request, httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpUriRequestBase httpRequest) {
        for (Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase(HttpHeaders.CONTENT_LENGTH)
                    || entry.getKey().equalsIgnoreCase(HttpHeaders.HOST)) {
                continue;
            }
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }

        // Set content type and encoding
        if (!httpRequest.containsHeader(HttpHeaders.CONTENT_TYPE)) {
            httpRequest.addHeader(HttpHeaders.CONTENT_TYPE,
                    "application/x-www-form-urlencoded; charset=" +
                            LmcConstant.DEFAULT_CHARSET_NAME.toLowerCase());
        }
    }
}
