package com.digiwin.dap.middleware.lmc.service.impl;

import com.digiwin.dap.middleware.lmc.service.LogLevelService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 日志级别service
 *
 * @author chenzhuang 2021-4-25 11:11:14
 */
public class LogLevelServiceImpl implements LogLevelService {
    private static final Logger logger = LoggerFactory.getLogger(LogLevelServiceImpl.class);

    private static LogLevelService logLevelService;

    /**
     * 单一实例
     *
     * @return
     */
    public static LogLevelService logLevelInstance() {
        if (logLevelService == null) {
            logLevelService = new LogLevelServiceImpl();
        }
        return logLevelService;
    }

    /**
     * 查询log4j2日志级别
     *
     * @return level.name
     */
    @Override
    public String getLogLevel() {
        org.apache.logging.log4j.core.LoggerContext ctx = (org.apache.logging.log4j.core.LoggerContext) LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(LogManager.ROOT_LOGGER_NAME);
        Level level = loggerConfig.getLevel();
        String name = level.name();

        System.out.println("=======日志级别为：" + name);
        logger.error("I am error");
        logger.warn("I am warn");
        logger.info("I am info");
        logger.debug("I am debug");
        return name;
    }

    /**
     * 修改log4j2日志级别
     *
     * @param logLevel debug、info、warn、error
     * @return 修改后的level.name
     */
    @Override
    public String updateLogLevel(String logLevel) {
        logLevel = logLevel.toLowerCase();
        org.apache.logging.log4j.core.LoggerContext ctx = (org.apache.logging.log4j.core.LoggerContext) LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig rootLogger = config.getLoggerConfig(LogManager.ROOT_LOGGER_NAME);
        switch (logLevel) {
            case "debug":
                rootLogger.setLevel(Level.DEBUG);
                break;
            case "info":
                rootLogger.setLevel(Level.INFO);
                break;
            case "warn":
                rootLogger.setLevel(Level.WARN);
                break;
            case "error":
                rootLogger.setLevel(Level.ERROR);
                break;
            default:
                logger.error("日志级别修改失败，不支持的日志级别logLevel=[{}]", logLevel);
        }
        ctx.updateLoggers();
        return rootLogger.getLevel().name();

    }


///**
// * logback日志级别查询
// * @return
// */
//@GetMapping("/logback")
//public ResponseEntity<?> logback() {
//    // 第一步：获取日志上下文
//    ch.qos.logback.classic.LoggerContext ctx = (ch.qos.logback.classic.LoggerContext) org.slf4j.LoggerFactory.getILoggerFactory();
//    // 第二步：获取日志对象 （日志是有继承关系的，关闭上层，下层如果没有特殊说明也会关闭）
//    ch.qos.logback.classic.Logger rootLogger = ctx.getLogger(org.slf4j.Logger.ROOT_LOGGER_NAME);
//    Level level = rootLogger.getLevel();
//    String name = level.toString();
//    System.out.println("=======日志级别为：" + name);
//    logger.error("=======我是error=======");
//    logger.warn("=======我是warn=======");
//    logger.info("=======我是info=======");
//    logger.debug("=======我是debug=======");
//    return ResponseEntity.ok(StdData.ofSuccess(name));
//}
//
//
///**
// * logback日志级别修改
// * @param logLevel
// * @return
// */
//@PutMapping("/logback/{logLevel}")
//public ResponseEntity<?> setLogbackLevel(@PathVariable String logLevel) {
//    StdData stdData = StdData.ok();
//    logLevel = logLevel.toLowerCase();
//    // 定义日志输出
//    // 第一步：获取日志上下文
//    ch.qos.logback.classic.LoggerContext ctx = (ch.qos.logback.classic.LoggerContext) org.slf4j.LoggerFactory.getILoggerFactory();
//    // 第二步：获取日志对象 （日志是有继承关系的，关闭上层，下层如果没有特殊说明也会关闭）
//    ch.qos.logback.classic.Logger rootLogger = ctx.getLogger(org.slf4j.Logger.ROOT_LOGGER_NAME);
//    // 第三步：修改日志级别
//    switch (logLevel) {
//        case "trace":
//            rootLogger.setLevel(ch.qos.logback.classic.Level.TRACE);
//            break;
//        case "debug":
//            rootLogger.setLevel(ch.qos.logback.classic.Level.DEBUG);
//            break;
//        case "info":
//            rootLogger.setLevel(ch.qos.logback.classic.Level.INFO);
//            break;
//        case "warn":
//            rootLogger.setLevel(ch.qos.logback.classic.Level.WARN);
//            break;
//        case "error":
//            rootLogger.setLevel(ch.qos.logback.classic.Level.ERROR);
//            break;
//        default:
//            stdData = StdData.ofFail(20000, "日志级别修改失败！");
//            break;
//    }
//    logger.debug("===== 我是 debug  =====");
//    logger.info("===== 我是 info  =====");
//    logger.error("===== 我是 ERROR  =====");
//    return ResponseEntity.ok(stdData);
//}
}
