/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.appender;

import com.digiwin.dap.middleware.lmc.internal.LMCResourceUri;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import com.digiwin.dap.middleware.lmc.util.LoggingEventSizeUtil;
import com.digiwin.dap.middleware.lmc.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.json.JSONArray;

@Plugin(name="DwLog4j2Appender", category="Core", elementType="appender", printObject=true)
public class DwLog4j2Appender
extends AbstractAppender {
    static final String PROPERTY_NAME_ASYNC_EVENT_ROUTER = "log4j2.AsyncQueueFullPolicy";
    static final String PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER = "Discard";
    private final SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String CUSTOM_CONTENT_KEY_SEPARATOR = ",";
    private static List<String> CUSTOM_CONTENT_KEY_LIST = new ArrayList<String>();
    private static final int DEFAULT_PERIOD_MILL_SECONDS = 2;
    private static final int DEFAULT_BATCH_SIZE = 50;
    private static final Long DEFAULT_MAX_LOG_SIZE = 10240L;
    private static final Integer DEFAULT_THREAD_NUM = 5;
    private ScheduledExecutorService executor;
    private int consumeCount = 0;
    private Queue<Map<String, Object>> workQueue = new LinkedList<Map<String, Object>>();
    private CloseableHttpClient client;
    private Integer intervals;
    private Integer batchSize;
    private Long maxSingleLogSize;
    private String customContentKey;
    private String endpoint;
    private String app;
    private String userAgent = "log4j2";

    protected DwLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout, String endpoint, String app, Integer intervals, Integer batchSize, Long maxSingleLogSize, String customContentKey) {
        super(name, filter, layout);
        this.endpoint = endpoint;
        this.app = app;
        this.intervals = intervals;
        this.batchSize = batchSize;
        this.maxSingleLogSize = maxSingleLogSize;
        this.customContentKey = customContentKey;
    }

    public void start() {
        super.start();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)3000L)).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)3000L)).setResponseTimeout(Timeout.ofMilliseconds((long)3000L)).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(4);
        cm.setDefaultMaxPerRoute(4);
        cm.setValidateAfterInactivity((TimeValue)Timeout.ofMilliseconds((long)2000L));
        this.client = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)cm).build();
        if (PropertiesUtil.getProperties().getStringProperty(PROPERTY_NAME_ASYNC_EVENT_ROUTER) == null) {
            System.setProperty(PROPERTY_NAME_ASYNC_EVENT_ROUTER, PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> {
            DwLog4j2Appender dwLog4j2Appender = this;
            synchronized (dwLog4j2Appender) {
                if (!this.workQueue.isEmpty()) {
                    LinkedList<Map<String, Object>> logList = new LinkedList<Map<String, Object>>();
                    for (Map map : this.workQueue) {
                        logList.add(map);
                    }
                    this.asyncPersistence(logList);
                    this.consumeCount = 0;
                    this.workQueue.clear();
                }
            }
        }, 0L, this.intervals.intValue(), TimeUnit.SECONDS);
        super.start();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        LinkedList<Map<String, Object>> logList = new LinkedList<Map<String, Object>>();
        for (Map map : this.workQueue) {
            logList.add(map);
        }
        this.asyncPersistence(logList);
        this.executor.shutdown();
        super.stop();
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException exception) {
                LOGGER.error(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        DwLog4j2Appender dwLog4j2Appender = this;
        synchronized (dwLog4j2Appender) {
            while (this.workQueue.size() > this.batchSize) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Map<String, Object> map = this.convertLogEventToMap(event);
            if (Objects.nonNull(map)) {
                if ((long)LoggingEventSizeUtil.getSize(map) >= this.maxSingleLogSize * 1024L) {
                    List<Map<String, Object>> log = Arrays.asList(map);
                    this.asyncPersistence(log);
                } else {
                    this.workQueue.offer(map);
                    ++this.consumeCount;
                }
            }
            if (this.consumeCount >= this.batchSize) {
                LinkedList<Map<String, Object>> logList = new LinkedList<Map<String, Object>>();
                for (Map map2 : this.workQueue) {
                    logList.add(map2);
                }
                this.asyncPersistence(logList);
                this.workQueue.clear();
                this.consumeCount = 0;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    private Map<String, Object> convertLogEventToMap(LogEvent event) {
        String traceId;
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        Map contextDataMap = event.getContextData().toMap();
        if (!contextDataMap.isEmpty()) {
            String ptxId = (String)contextDataMap.get("PtxId");
            traceId = ptxId != null && !"".equals(ptxId) ? ptxId : LogUtils.getUUID();
            HashMap customContent = new HashMap();
            CUSTOM_CONTENT_KEY_LIST.forEach(key -> {
                if (Objects.nonNull(contextDataMap.get(key))) {
                    customContent.put(key, (String)contextDataMap.get(key));
                }
            });
            logMap.put("customContent", customContent);
        } else {
            traceId = LogUtils.getUUID();
        }
        logMap.putIfAbsent("traceId", traceId);
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", this._sdf.format(new Date(event.getTimeMillis())));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);
        logMap.putIfAbsent("appender", "DwLog4j2Appender");
        StackTraceElement source = event.getSource();
        if (source == null && !event.isIncludeLocation()) {
            event.setIncludeLocation(true);
            source = event.getSource();
            event.setIncludeLocation(false);
        }
        logMap.putIfAbsent("location", source == null ? "Unknown(Unknown Source)" : source.toString());
        String message = event.getMessage().getFormattedMessage();
        logMap.putIfAbsent("message", message);
        if (Objects.nonNull(event.getThrown())) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (String s : Throwables.toStringList((Throwable)event.getThrown())) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(System.getProperty("line.separator"));
                }
                sb.append(s);
            }
            logMap.putIfAbsent("throwable", sb.toString());
        }
        if (this.getLayout() != null) {
            logMap.putIfAbsent("log", new String(this.getLayout().toByteArray(event)));
        }
        return logMap;
    }

    private void asyncPersistence(List<Map<String, Object>> logList) {
        ThreadPoolUtil.executor(() -> {
            if (logList == null || logList.isEmpty()) {
                return;
            }
            HttpPost post = new HttpPost(LMCResourceUri.getSaveDevLogBatchUrl(this.endpoint));
            try {
                JSONArray jsonArray = new JSONArray((Collection)logList);
                post.setEntity((HttpEntity)new StringEntity(jsonArray.toString(), ContentType.APPLICATION_JSON));
                ClassicHttpResponse response = (ClassicHttpResponse)this.client.execute((ClassicHttpRequest)post, httpResponse -> httpResponse);
                if (response.getCode() != 200) {
                    post.cancel();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        });
    }

    @PluginFactory
    public static DwLog4j2Appender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="endpoint") String endpoint, @PluginAttribute(value="app") String app, @PluginAttribute(value="intervals") Integer intervals, @PluginAttribute(value="batchSize") Integer batchSize, @PluginAttribute(value="maxSingleLogSize") Long maxSingleLogSize, @PluginAttribute(value="customContentKey") String customContentKey) {
        if (name == null) {
            LOGGER.error("no name defined in conf.");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (0 == intervals) {
            intervals = 2;
        }
        if (0 == batchSize) {
            batchSize = 50;
        }
        if (Objects.equals(0L, maxSingleLogSize)) {
            maxSingleLogSize = DEFAULT_MAX_LOG_SIZE;
        }
        if (null != customContentKey && customContentKey.length() != 0) {
            CUSTOM_CONTENT_KEY_LIST = Arrays.asList(customContentKey.split(CUSTOM_CONTENT_KEY_SEPARATOR));
        }
        return new DwLog4j2Appender(name, filter, (Layout<? extends Serializable>)layout, endpoint, app, intervals, batchSize, maxSingleLogSize, customContentKey);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public CloseableHttpClient getHttpClient() {
        return this.client;
    }

    public void setHttpClient(CloseableHttpClient client) {
        this.client = client;
    }

    public Integer getIntervals() {
        return this.intervals;
    }

    public void setIntervals(Integer intervals) {
        this.intervals = intervals;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Long getMaxSingleLogSize() {
        return this.maxSingleLogSize;
    }

    public void setMaxSingleLogSize(Long maxSingleLogSize) {
        this.maxSingleLogSize = maxSingleLogSize;
    }

    public String getCustomContentKey() {
        return this.customContentKey;
    }

    public void setCustomContentKey(String customContentKey) {
        this.customContentKey = customContentKey;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

