/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.comm.HttpDeleteWithBody;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.HttpMethod;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import java.net.URI;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpUriRequestBase createHttpRequest(RequestMessage request) {
        Object httpRequest;
        URI uri = request.getEndpoint();
        HttpMethod method = request.getMethod();
        switch (method) {
            case POST: {
                HttpPost post = new HttpPost(uri);
                if (request.getHttpEntity() != null) {
                    post.setEntity(request.getHttpEntity());
                }
                httpRequest = post;
                break;
            }
            case PUT: {
                HttpPut put = new HttpPut(uri);
                if (request.getHttpEntity() != null) {
                    put.setEntity(request.getHttpEntity());
                }
                httpRequest = put;
                break;
            }
            case GET: {
                httpRequest = new HttpGet(uri);
                break;
            }
            case DELETE: {
                if (request.getHttpEntity() != null) {
                    HttpDeleteWithBody delete = new HttpDeleteWithBody(uri);
                    delete.setEntity(request.getHttpEntity());
                    httpRequest = delete;
                    break;
                }
                httpRequest = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                httpRequest = new HttpHead(uri);
                break;
            }
            case OPTIONS: {
                httpRequest = new HttpOptions(uri);
                break;
            }
            default: {
                throw new ClientException("Unknown HTTP method name: " + (Object)((Object)method));
            }
        }
        this.configureRequestHeaders(request, (HttpUriRequestBase)httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpUriRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
        }
        if (!httpRequest.containsHeader("Content-Type")) {
            httpRequest.addHeader("Content-Type", (Object)("application/x-www-form-urlencoded; charset=" + "utf-8".toLowerCase()));
        }
    }
}

