package com.digiwin.dap.middleware.lmc.request;

import java.util.Map;

/**
 * 分页查询请求
 *
 * @author chenzhuang
 * @date 2021/5/12 21:51
 */
public class PageOpLogRequest extends PageRequest {
    private static final long serialVersionUID = -3073834810947275358L;
    /**
     * 操作日志查询条件DTO
     *
     * <p>
     * appId必填
     * 例如：
     * {"appId":"应用id","moduleId":"模组id","actId":"行为id","operationType":"update,delete,insert等", "tenantId": "",
     * "tenantName": "","primaryKey":"","modifyById": "陈壮","createById":"chenzhuang","operationObject": "操作对象陈壮",
     * "createDateStart": "2020-03-01 00:00:00", "createDateEnd": "2020-04-01 00:00:00","content":{"email":"317026517@qq.com"},
     *
     * "source": "来源", "actionId": "操作类型","primaryName":"主键名称", "editUserId": "陈壮",
     * "editPlace": "编辑地点", "actionIds":["001"，"002"], "beginTime": "editTime的开始时间",
     * "endTime": "editTime的结束时间"}
     */
    private OpLogDTO opLogDTO;

    public PageOpLogRequest() {
    }

    public PageOpLogRequest(OpLogDTO opLogDTO, Integer pageNum, Integer pageSize, Map<String, Object> orders) {
        super(pageNum, pageSize, orders);
        this.opLogDTO = opLogDTO;
    }

    public OpLogDTO getOpLogDTO() {
        return opLogDTO;
    }

    public void setOpLogDTO(OpLogDTO opLogDTO) {
        this.opLogDTO = opLogDTO;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.opLogDTO != null) {
            addObjectParams(this.opLogDTO);
        }
        return super.getParameters();
    }
}
