package com.digiwin.dap.middleware.lmc.request;

import com.digiwin.dap.middleware.lmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

/**
 * 功能描述
 *
 * @author chenzhuang
 * @date 2021/5/14 9:48
 */
public class SaveOpLogRequest extends GenericRequest {
    private static final long serialVersionUID = -4211635608129073160L;
    private SaveOpLog saveOpLog;

    public SaveOpLogRequest() {
    }

    public SaveOpLogRequest(SaveOpLog saveOpLog) {
        this.saveOpLog = saveOpLog;
    }

    public SaveOpLog getSaveOpLog() {
        return saveOpLog;
    }

    public void setSaveOpLog(SaveOpLog saveOpLog) {
        this.saveOpLog = saveOpLog;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(this.saveOpLog))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
