package com.digiwin.dap.middleware.lmc.util;

import org.apache.logging.log4j.core.LogEvent;
import org.slf4j.event.LoggingEvent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Objects;

public class LoggingEventSizeUtil {
    public static int getSize(Object object) {
        if(Objects.isNull(object)){
            return 0;
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try{
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            oos.close();
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            if (oos != null) {
                try {
                    oos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                bos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return bos.size();
    }
}
