/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.service.impl;

import com.digiwin.dap.middleware.lmc.service.LogLevelService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelServiceImpl
implements LogLevelService {
    private static final Logger logger = LoggerFactory.getLogger(LogLevelServiceImpl.class);
    private static LogLevelService logLevelService;

    public static LogLevelService logLevelInstance() {
        if (logLevelService == null) {
            logLevelService = new LogLevelServiceImpl();
        }
        return logLevelService;
    }

    @Override
    public String getLogLevel() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        Level level = loggerConfig.getLevel();
        String name = level.name();
        System.out.println("=======\u65e5\u5fd7\u7ea7\u522b\u4e3a\uff1a" + name);
        logger.error("I am error");
        logger.warn("I am warn");
        logger.info("I am info");
        logger.debug("I am debug");
        return name;
    }

    @Override
    public String updateLogLevel(String logLevel) {
        logLevel = logLevel.toLowerCase();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig rootLogger = config.getLoggerConfig("");
        switch (logLevel) {
            case "debug": {
                rootLogger.setLevel(Level.DEBUG);
                break;
            }
            case "info": {
                rootLogger.setLevel(Level.INFO);
                break;
            }
            case "warn": {
                rootLogger.setLevel(Level.WARN);
                break;
            }
            case "error": {
                rootLogger.setLevel(Level.ERROR);
                break;
            }
            default: {
                logger.error("\u65e5\u5fd7\u7ea7\u522b\u4fee\u6539\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u65e5\u5fd7\u7ea7\u522blogLevel=[{}]", (Object)logLevel);
            }
        }
        ctx.updateLoggers();
        return rootLogger.getLevel().name();
    }
}

