/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.appender;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;

public class DwLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private CloseableHttpClient client;
    private String app;
    private String endpoint;
    protected Encoder<E> encoder;
    private String userAgent = "logback";

    public void start() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.addError("Failed to start LoghubAppender.", e);
        }
    }

    private void doStart() {
        super.start();
        this.endpoint = this.endpoint + "/api/lmc/v1/devlog";
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.addError("Failed to stop LoghubAppender.", e);
        }
    }

    private void doStop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException var2) {
                this.addError(var2.getMessage());
            }
        }
    }

    public void append(E eventObject) {
        try {
            this.appendEvent(eventObject);
        }
        catch (Exception e) {
            this.addError("Failed to append event.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendEvent(E eventObject) {
        CloseableHttpResponse h_response = null;
        if (!(eventObject instanceof LoggingEvent)) {
            return;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        HttpPost postMethod = new HttpPost(this.getEndpoint());
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", this._sdf.format(new Date()));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);
        logMap.putIfAbsent("appender", "DwLog4j2Appender");
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            logMap.putIfAbsent("location", caller[0].toString());
        }
        String message = event.getFormattedMessage();
        logMap.putIfAbsent("message", message);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            String throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = throwable + this.fullDump(event.getThrowableProxy().getStackTraceElementProxyArray());
            logMap.putIfAbsent("throwable", throwable);
        }
        if (this.encoder != null) {
            logMap.putIfAbsent("log", new String(this.encoder.encode(eventObject)));
        }
        JSONObject tmepObject = new JSONObject(logMap);
        String formatValue = tmepObject.toString(5);
        postMethod.setEntity((HttpEntity)new StringEntity(formatValue, ContentType.APPLICATION_JSON));
        try {
            h_response = this.client.execute((HttpUriRequest)postMethod);
            HttpEntity repEntity = h_response.getEntity();
            int statusCode = h_response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                postMethod.abort();
            }
        }
        catch (ConnectTimeoutException var23) {
            this.addError(var23.getMessage());
        }
        catch (SocketTimeoutException var24) {
            this.addError(var24.getMessage());
        }
        catch (Exception var25) {
            this.addError(var25.getMessage());
        }
        finally {
            if (h_response != null) {
                try {
                    h_response.close();
                }
                catch (IOException var22) {
                    this.addError(var22.getMessage());
                }
            }
        }
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }

    private String fullDump(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

