package com.digiwin.dap.middleware.lmc.request;

import com.digiwin.dap.middleware.lmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.HashMap;
import java.util.Map;

/**
 * 分页查询请求
 *
 * @author chenzhuang
 * @date 2021/5/12 21:51
 */
public class PageRequest extends GenericRequest {
    private static final long serialVersionUID = -5149085030163337257L;
    private Integer pageNum;
    private Integer pageSize;
    /**
     * 排序 json格式 -1倒叙 1正序
     * 例如 {createTime : -1, name : 1}
     */
    private Map<String, Object> orders;
    /**
     * 查询条件 json格式
     */
    private Map<String, Object> params = new HashMap<>();

    public PageRequest() {
    }

    public PageRequest(Integer pageNum, Integer pageSize, Map<String, Object> orders) {
        this(pageNum, pageSize, orders, null);
    }

    public PageRequest(Integer pageNum, Integer pageSize, Map<String, Object> orders, Map<String, Object> params) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.orders = orders;
        this.params = params;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Map<String, Object> getOrders() {
        return orders;
    }

    public void setOrders(Map<String, Object> orders) {
        this.orders = orders;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public PageRequest addObjectParams(Object obj) {
        if (obj == null) {
            return this;
        }
        if (this.params == null) {
            this.params = new HashMap<>();
        }
        this.params.putAll(JsonUtils.createObjectMapper().convertValue(obj, new TypeReference<Map<String, Object>>(){}));
        return this;
    }

    public PageRequest addParams(Map<String, String> params) {
        this.params.putAll(params);
        return this;
    }

    public Map<String,String> getParameters(){
        Map<String, String> parameters = new HashMap<>();
        if (this.pageNum != null) {
            parameters.put("pageNum", String.valueOf(this.pageNum));
        }
        if (this.pageSize != null) {
            parameters.put("pageSize",String.valueOf(this.pageSize));
        }
        if (this.orders != null) {
            parameters.put("orders", JsonUtils.writeValueAsString(this.orders));
        }
        if (this.params != null) {
            parameters.put("params", JsonUtils.writeValueAsString(this.params));
        }
        return parameters;
    }

}
