package com.digiwin.dap.middleware.lmc.service;

/**
 * 日志级别service
 * <p>
 * 应用引入SDK后，可以自己实现调用LogLevelService，进行日志级别的查询和修改
 * 生产环境修改日志级别时需谨慎，debug、info级别可能会产生大量日志，完成后应及时修正
 */
public interface LogLevelService {

    /**
     * 查询日志级别
     *
     * @return level.name
     */
    String getLogLevel();

    /**
     * 修改日志级别
     * <p>
     * 动态修改日志级别，重启后失效会以配置文件稳准。
     * 生产环境修改日志级别时需谨慎，debug、info级别可能会产生大量日志，完成后应及时修正。
     *
     * @param logLevel 日志级别debug、info、warn、error
     * @return 修改后的level.name
     */
    String updateLogLevel(String logLevel);

}
