package com.digiwin.dap.middleware.lmc.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;

import java.util.Calendar;
import java.util.Date;

/**
 * @author chenxsa
 * @date: 2018-6-6 15:27
 * @Description:
 */
public class JwtUtil {
    /**
     * 校验token是否过期
     *
     * @param token  密钥
     * @return 是否正确
     */
    public static boolean isExpires(String token) {
        try {
            DecodedJWT decodedJWT=   JWT.decode(token);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(Calendar.SECOND, 30);
            if (cal.getTime().before(decodedJWT.getExpiresAt() ) ){
                return false;
            }
            return true;
        }catch (JWTVerificationException exception) {
            return  true;
        }
        catch (Exception e){
            return true;
        }
    }
}
