/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.appender;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.digiwin.dap.middleware.lmc.util.CryptoUtil;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Deprecated
public class DwMongoLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;
    private MongoCollection<BasicDBObject> logsCollection;
    private List<String> tracerKeysList;
    private String connectionUrl;
    private String userName;
    private String password;
    private String databaseName = "lmc";
    private String collectionName;
    private String server;
    private String port;
    private String app;
    private String traceKeys;
    protected Encoder<E> encoder;
    private String userAgent = "logback";

    public void start() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.addError("Failed to start LoghubAppender.", e);
        }
    }

    private void doStart() {
        super.start();
        if (this.userName != null && !"".equals(this.userName)) {
            if (this.password != null) {
                this.password = CryptoUtil.dapDecode(this.password);
            }
            this.setConnectionUrl("mongodb://" + this.userName + ":" + this.password + "@" + this.server + ":" + this.port);
        } else {
            this.setConnectionUrl("mongodb://" + this.server + ":" + this.port);
        }
        this.collectionName = (this.app + "_devlog").toLowerCase();
        MongoClientURI connectionString = new MongoClientURI(this.connectionUrl);
        this.mongoClient = new MongoClient(connectionString);
        this.mongoDatabase = this.mongoClient.getDatabase(this.databaseName);
        this.logsCollection = this.mongoDatabase.getCollection(this.collectionName, BasicDBObject.class);
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.addError("Failed to stop LoghubAppender.", e);
        }
    }

    private void doStop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    public void append(E eventObject) {
        try {
            this.appendEvent(eventObject);
        }
        catch (Exception e) {
            this.addError("Failed to append event.", e);
        }
    }

    private void appendEvent(E eventObject) {
        String ptxId;
        if (!(eventObject instanceof LoggingEvent)) {
            return;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        Map mdcPropertyMap = event.getMDCPropertyMap();
        String traceId = !mdcPropertyMap.isEmpty() ? ((ptxId = (String)mdcPropertyMap.get("PtxId")) != null && !"".equals(ptxId) ? ptxId : LogUtils.getUUID()) : LogUtils.getUUID();
        logMap.putIfAbsent("traceId", traceId);
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", this._sdf.format(new Date()));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);
        logMap.putIfAbsent("appender", "DwMongoLogbackAppender");
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            logMap.putIfAbsent("location", caller[0].toString());
        }
        String message = event.getFormattedMessage();
        logMap.putIfAbsent("message", message);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            String throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = throwable + this.fullDump(event.getThrowableProxy().getStackTraceElementProxyArray());
            logMap.putIfAbsent("throwable", throwable);
        }
        if (this.encoder != null) {
            logMap.putIfAbsent("log", new String(this.encoder.encode(eventObject)));
        }
        BasicDBObject document = new BasicDBObject();
        document.putAll(logMap);
        this.logsCollection.insertOne((Object)document);
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }

    private String fullDump(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getTraceKeys() {
        return this.traceKeys;
    }

    public void setTraceKeys(String traceKeys) {
        if (traceKeys != null && !"".equals(traceKeys)) {
            this.traceKeys = traceKeys;
            this.tracerKeysList = Stream.of(traceKeys.split(",")).map(String::trim).collect(Collectors.toList());
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

