/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.internal;

import com.digiwin.dap.middleware.lmc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.lmc.common.parser.ResponseParser;
import com.digiwin.dap.middleware.lmc.exception.LMCException;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.ServiceException;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ServiceClient;
import com.digiwin.dap.middleware.lmc.http.utils.ExceptionFactory;
import com.digiwin.dap.middleware.lmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.lmc.internal.model.StdError;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.dap.middleware.lmc.util.LMCUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMCOperation {
    protected static final Logger logger = LoggerFactory.getLogger(LMCOperation.class);
    protected ServiceClient serviceClient;

    public LMCOperation(ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public <T> T doOperation(RequestMessage request, ResponseParser<T> parser) throws LMCException, ClientException {
        ResponseMessage response = this.sendRequest(request);
        try {
            return parser.parse(response);
        }
        catch (ResponseParseException rpe) {
            LMCException oe = ExceptionFactory.createBadResponseException(response.getRequestId(), rpe.getMessage(), rpe);
            logger.error("Unable to parse response error: ", (Throwable)rpe);
            throw oe;
        }
    }

    public ResponseMessage sendRequest(RequestMessage request) throws LMCException, ClientException {
        ResponseMessage response = null;
        try {
            response = this.serviceClient.sendRequest(request);
            this.extractResponseBody(response);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                String requestId = this.getRequestId(response.getHeaders());
                try {
                    StdError stdError = this.parseResponseBody(response, requestId);
                    this.errorCheck(stdError, requestId, statusCode);
                }
                catch (LMCException ex) {
                    ex.setHttpCode(response.getStatusCode());
                    throw ex;
                }
            }
            ResponseMessage responseMessage = response;
            return responseMessage;
        }
        catch (ServiceException e) {
            throw new LMCException("Web request failed: " + e.getMessage(), "RequestError", "", e);
        }
        catch (ClientException e) {
            throw new LMCException("Web request failed: " + e.getMessage(), "RequestError", "", e);
        }
        finally {
            if (response != null) {
                LMCUtils.safeCloseResponse(response);
            }
        }
    }

    private void extractResponseBody(ResponseMessage response) throws LMCException {
        InputStream in = response.getContent();
        if (in == null) {
            return;
        }
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        String requestId = this.getRequestId(response.getHeaders());
        try {
            int ch;
            byte[] cache = new byte[1024];
            while ((ch = in.read(cache, 0, 1024)) != -1) {
                bytestream.write(cache, 0, ch);
            }
        }
        catch (IOException e) {
            throw new LMCException("Io exception happened when parse the response data : ", "BadResponse", requestId, e);
        }
        response.SetBody(bytestream.toByteArray());
    }

    protected String getRequestId(Map<String, String> headers) {
        return LMCUtils.getOrEmpty(headers, "digi-middleware-request-id");
    }

    private StdError parseResponseBody(ResponseMessage response, String requestId) throws LMCException {
        String body = LMCOperation.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return ResponseParsers.errorResponseParser.parse(response);
        }
        catch (ResponseParseException ex) {
            throw new LMCException("The response is not valid json string to map: " + body, "BadResponse", requestId, ex);
        }
    }

    private static String encodeResponseBodyToUtf8String(ResponseMessage response, String requestId) throws LMCException {
        byte[] body = response.GetRawBody();
        if (body == null) {
            throw new LMCException("The response body is null", "BadResponse", requestId);
        }
        try {
            return new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LMCException("The response is not valid utf-8 string: ", "BadResponse", requestId, e);
        }
    }

    protected void errorCheck(StdError stdError, String requestId, int httpCode) throws LMCException {
        if (stdError.getErrorCode() != null && !"".equals(stdError.getErrorCode())) {
            String errorMessage = stdError.getErrorMessage();
            if (stdError.getMessage() != null) {
                errorMessage = errorMessage + " : " + stdError.getMessage();
            }
            throw new LMCException(httpCode, stdError.getErrorCode(), errorMessage, requestId);
        }
        throw new LMCException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + JsonUtils.writeValueAsString(stdError), requestId);
    }
}

