package com.digiwin.dap.middleware.lmc.common.parser;


import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.internal.model.StdError;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;

/**
 * Used to convert an result stream to a java object.
 *
 * @author chenzhuang
 * @date 2021/4/23
 */
public class ErrorResponseParser implements ResponseParser<StdError> {

    @Override
    public StdError parse(ResponseMessage response) throws ResponseParseException {
        return JsonUtils.readValue(response.getErrorResponseAsString(), StdError.class);
    }
}
