package com.digiwin.dap.middleware.lmc.request;

import java.util.Map;

/**
 * 分页查询请求
 *
 * @author chenzhuang
 * @date 2021/5/14 17:16
 */
public class PageEventLogRequest extends PageRequest {
    private static final long serialVersionUID = -5307799206164789529L;
    /**
     * 时间日志查询条件DTO
     *
     * <p>
     * appId 必填
     * 例如：
     * {"appId":"应用id【必填】","eventId":"事件id","eventName":"事件名称内容","eventType":"事件类型（0其他,1查询,2新增,3修改,4删除,5授权,6导入,7导出,
     * 8登入,9登出,10清空数据）","tenantId":"租户id","tenantContent":"租户id或者名称","sysId":"应用id","sysContent":"应用id或者名称", "userId":"操作人id",
     * "userContent":"操作人员","eventSource":"事件来源",
     * "content":{"email":"自定义信息查询如317026517@qq.com"},"createDateStart":"2020-03-01 00:00:00",createDateEnd":"2021-04-01 00:00:00"}
     */
    private EventLogDTO eventLogDTO;

    public PageEventLogRequest(EventLogDTO eventLogDTO) {
        this.eventLogDTO = eventLogDTO;
    }

    public PageEventLogRequest(EventLogDTO eventLogDTO, Integer pageNum, Integer pageSize, Map<String, Object> orders) {
        super(pageNum, pageSize, orders);
        this.eventLogDTO = eventLogDTO;
    }

    public EventLogDTO getEventLogDTO() {
        return eventLogDTO;
    }

    public void setEventLogDTO(EventLogDTO eventLogDTO) {
        this.eventLogDTO = eventLogDTO;
    }

    @Override
    public Map<String, String> getParameters() {
        if (this.eventLogDTO != null) {
            addObjectParams(this.eventLogDTO);
        }
        return super.getParameters();
    }
}
