/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.common.auth;

import com.digiwin.dap.middleware.lmc.common.auth.AuthCache;
import com.digiwin.dap.middleware.lmc.util.JwtUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BasicAuthCache
implements AuthCache {
    private final Map<String, String> tokenMap = new ConcurrentHashMap<String, String>();

    @Override
    public void put(String endpoint, String token) {
        this.tokenMap.put(endpoint, token);
    }

    @Override
    public String get(String endpoint) {
        String token = this.tokenMap.get(endpoint);
        if (JwtUtil.isExpires(token)) {
            return null;
        }
        return token;
    }

    @Override
    public void remove(String endpoint) {
        this.tokenMap.remove(endpoint);
    }

    @Override
    public void clear() {
        this.tokenMap.clear();
    }
}

