/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.common.comm;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdleConnectionReaper
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IdleConnectionReaper.class);
    private static final int REAP_INTERVAL_MILLISECONDS = 5000;
    private static final CopyOnWriteArrayList<PoolingHttpClientConnectionManager> connectionManagers = new CopyOnWriteArrayList();
    private static IdleConnectionReaper instance;
    private static volatile long idleConnectionTime;
    private volatile boolean shuttingDown;

    private IdleConnectionReaper() {
        super("idle-connection-reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(PoolingHttpClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        return connectionManagers.addIfAbsent(connectionManager);
    }

    public static synchronized boolean removeConnectionManager(PoolingHttpClientConnectionManager connectionManager) {
        boolean removed = connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
        return removed;
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    public static int size() {
        return connectionManagers.size();
    }

    public static void setIdleConnectionTime(long idletime) {
        idleConnectionTime = idletime;
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    @Override
    public void run() {
        block6: while (true) {
            if (this.shuttingDown) {
                logger.debug("Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                CopyOnWriteArrayList<PoolingHttpClientConnectionManager> managersSnapshot = connectionManagers;
                Iterator iterator = managersSnapshot.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block6;
                    PoolingHttpClientConnectionManager connectionManager = (PoolingHttpClientConnectionManager)iterator.next();
                    try {
                        connectionManager.closeExpired();
                        connectionManager.closeIdle(TimeValue.of((long)idleConnectionTime, (TimeUnit)TimeUnit.MILLISECONDS));
                    }
                    catch (Exception ex) {
                        logger.warn("Unable to close idle connections", (Throwable)ex);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Reaper thread: ", t);
                continue;
            }
            break;
        }
    }

    static {
        idleConnectionTime = 60000L;
    }
}

