/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.http.comm;

import com.digiwin.dap.middleware.lmc.common.auth.AuthCache;
import com.digiwin.dap.middleware.lmc.http.client.ClientConfiguration;
import com.digiwin.dap.middleware.lmc.http.client.ClientException;
import com.digiwin.dap.middleware.lmc.http.client.ServiceException;
import com.digiwin.dap.middleware.lmc.http.comm.RequestMessage;
import com.digiwin.dap.middleware.lmc.http.comm.ResponseMessage;
import com.digiwin.dap.middleware.lmc.http.utils.CodingUtils;
import com.digiwin.dap.middleware.lmc.http.utils.HttpUtil;
import com.digiwin.dap.middleware.lmc.util.LMCUtils;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceClient {
    protected static final Logger logger = LoggerFactory.getLogger(ServiceClient.class);
    protected ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.config;
    }

    protected abstract ResponseMessage sendRequestCore(RequestMessage var1) throws IOException;

    public abstract AuthCache getAuthCache();

    public abstract void setAuthCache(String var1, String var2);

    public abstract void shutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request) throws ServiceException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException ex) {
                logger.error("Unexpected io exception when trying to close http request: ", (Throwable)ex);
                throw new ClientException("Unexpected io exception when trying to close http request: ", ex);
            }
        }
    }

    public ResponseMessage sendRequestImpl(RequestMessage request) throws ServiceException, ClientException {
        Object response = null;
        try {
            this.buildRequest(request, "UTF-8");
            return this.sendRequestCore(request);
        }
        catch (ServiceException ex) {
            logger.error("[Server]Unable to execute HTTP request: ", (Throwable)ex);
            throw ex;
        }
        catch (ClientException ex) {
            logger.error("[Client]Unable to execute HTTP request: ", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error("[Unknown]Unable to execute HTTP request: ", (Throwable)ex);
            throw new ClientException(LMCUtils.COMMON_RESOURCE_MANAGER.getFormattedString("ConnectionError", ex.getMessage()), ex);
        }
    }

    private RequestMessage buildRequest(RequestMessage request, String charset) throws ClientException {
        String paramString = HttpUtil.paramToQueryString(request.getParameters(), charset);
        Object uri = request.getEndpoint().toString();
        if (paramString != null) {
            uri = (String)uri + "?" + paramString;
        }
        request.setEndpoint(URI.create((String)uri));
        return request;
    }
}

